/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.coins;

import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.coins.CoinBag;
import dev.ithundxr.createnumismatics.registry.NumismaticsItems;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Couple;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DiscreteCoinBag
implements CoinBag {
    private final Map<Coin, Integer> coins = new HashMap<Coin, Integer>();
    private int value = 0;

    protected DiscreteCoinBag(Map<Coin, Integer> coins) {
        this.coins.putAll(coins);
        this.calculateValue();
    }

    public DiscreteCoinBag() {
    }

    private void calculateValue() {
        this.value = 0;
        for (Map.Entry<Coin, Integer> entry : this.coins.entrySet()) {
            this.value += entry.getKey().toSpurs(entry.getValue());
        }
    }

    @Override
    public void add(Coin coin, int count) {
        this.coins.put(coin, (Integer)this.get(coin).getFirst() + count);
        this.calculateValue();
    }

    @Override
    public void subtract(Coin coin, int count) {
        this.coins.put(coin, Math.max(0, (Integer)this.get(coin).getFirst() - count));
        this.calculateValue();
    }

    @Override
    public void set(Coin coin, int count, int spurRemainder) {
        if (spurRemainder != 0) {
            Numismatics.LOGGER.warn("DiscreteCoinBag.set() called with spurRemainder != 0");
        }
        count = Math.max(0, count);
        this.coins.put(coin, count);
        this.calculateValue();
    }

    public void setDiscrete(Coin coin, int count) {
        this.set(coin, count, 0);
    }

    @Override
    public Couple<Integer> get(Coin coin) {
        return Couple.create((Object)this.coins.getOrDefault((Object)coin, 0), (Object)0);
    }

    public int getDiscrete(Coin coin) {
        return (Integer)this.get(coin).getFirst();
    }

    @Override
    public ItemStack asStack(Coin coin) {
        int amt = (Integer)this.get(coin).getFirst();
        if (amt == 0) {
            return ItemStack.f_41583_;
        }
        return NumismaticsItems.getCoin(coin).asStack(amt);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return this.value == 0;
    }

    @Override
    public CompoundTag save(CompoundTag nbt) {
        for (Map.Entry<Coin, Integer> entry : this.coins.entrySet()) {
            if (entry.getValue() <= 0) continue;
            nbt.m_128405_(entry.getKey().name(), entry.getValue().intValue());
        }
        return nbt;
    }

    @Override
    public void load(CompoundTag nbt) {
        this.coins.clear();
        for (Coin coin : Coin.values()) {
            if (!nbt.m_128441_(coin.name())) continue;
            this.coins.put(coin, nbt.m_128451_(coin.name()));
        }
        this.calculateValue();
    }

    public static DiscreteCoinBag of(CompoundTag nbt) {
        DiscreteCoinBag bag = new DiscreteCoinBag();
        bag.load(nbt);
        return bag;
    }

    public static DiscreteCoinBag of(Map<Coin, Integer> coins) {
        return new DiscreteCoinBag(coins);
    }

    public static DiscreteCoinBag of() {
        return new DiscreteCoinBag();
    }

    @Override
    public void clear() {
        this.coins.clear();
    }

    public void dropContents(Level level, BlockPos pos) {
        this.dropContents(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void dropContents(Level level, Entity entityAt) {
        this.dropContents(level, entityAt.m_20185_(), entityAt.m_20186_(), entityAt.m_20189_());
    }

    private void dropContents(Level level, double x, double y, double z) {
        this.coins.forEach((coin, amount) -> Containers.m_18992_((Level)level, (double)x, (double)y, (double)z, (ItemStack)coin.asStack((int)amount)));
    }
}

