/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlockEntity;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorBlock;
import dev.ithundxr.createnumismatics.content.depositor.AndesiteDepositorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import java.util.List;
import net.createmod.catnip.lang.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndesiteDepositorBlockEntity
extends AbstractDepositorBlockEntity
implements MenuProvider,
WorldlyContainer {
    @NotNull
    private Coin coin = Coin.SPUR;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] NO_SLOTS = new int[0];
    @NotNull
    private ItemStack inputStack = ItemStack.f_41583_;

    public AndesiteDepositorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Coin coin = this.getCoin();
        Lang.builder((String)"numismatics").add(Component.m_237110_((String)"block.numismatics.andesite_depositor.tooltip.price", (Object[])new Object[]{1, Component.m_237115_((String)coin.getTranslationKey()).m_7220_((Component)Component.m_237113_((String)(" " + coin.fontChar)).m_130940_(ChatFormatting.WHITE)), coin.value}).m_130940_(coin.rarity.f_43022_)).forGoggles(tooltip);
        return true;
    }

    public void setCoin(@NotNull Coin coin) {
        this.coin = coin;
    }

    @NotNull
    public Coin getCoin() {
        return this.coin;
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"block.numismatics.andesite_depositor");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, @NotNull Player player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new AndesiteDepositorMenu((MenuType)NumismaticsMenuTypes.ANDESITE_DEPOSITOR.get(), i, inventory, this);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (!this.inputStack.m_41619_()) {
            tag.m_128365_("InputStack", (Tag)this.inputStack.m_41739_(new CompoundTag()));
        }
        tag.m_128405_("Coin", this.coin.ordinal());
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.inputStack = tag.m_128425_("InputStack", 10) ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("InputStack")) : ItemStack.f_41583_;
        int coinIdx = 0;
        if (tag.m_128425_("ScrollValue", 3)) {
            coinIdx = tag.m_128451_("ScrollValue");
        } else if (tag.m_128425_("Coin", 3)) {
            coinIdx = tag.m_128451_("Coin");
        }
        this.coin = Coin.values()[coinIdx];
    }

    @Override
    public void lazyTick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Item item;
            if (!this.inputStack.m_41619_() && (item = this.inputStack.m_41720_()) instanceof CoinItem) {
                CoinItem coinItem = (CoinItem)item;
                this.inventory.add(coinItem.coin, this.inputStack.m_41613_());
                this.m_6596_();
                if (coinItem.coin == this.getCoin()) {
                    this.activate();
                }
            }
            this.inputStack = ItemStack.f_41583_;
        }
        super.lazyTick();
    }

    protected boolean isContainerActive() {
        return (Boolean)this.m_58900_().m_61143_((Property)AndesiteDepositorBlock.LOCKED) == false && (Boolean)this.m_58900_().m_61143_((Property)AndesiteDepositorBlock.POWERED) == false;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        if (side == Direction.UP && this.isContainerActive()) {
            return SLOTS_FOR_UP;
        }
        return NO_SLOTS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (!this.isContainerActive()) return false;
        if (direction != Direction.UP) return false;
        Item item = itemStack.m_41720_();
        if (!(item instanceof CoinItem)) return false;
        CoinItem coinItem = (CoinItem)item;
        if (coinItem.coin != this.getCoin()) return false;
        return true;
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return false;
    }

    public int m_6643_() {
        return this.isContainerActive() ? 1 : 0;
    }

    public boolean m_7983_() {
        return !this.isContainerActive() || this.inputStack.m_41619_();
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.inputStack;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        if (this.inputStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return this.inputStack.m_41620_(amount);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack ret = this.inputStack;
        this.inputStack = ItemStack.f_41583_;
        return ret;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.inputStack = stack;
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return false;
    }

    public void m_6211_() {
        this.inputStack = ItemStack.f_41583_;
    }

    @Override
    public void openTrustListMenu(ServerPlayer player) {
        TrustListMenu.openMenu(this, player, NumismaticsBlocks.ANDESITE_DEPOSITOR.asStack());
    }
}

