/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Label;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceConfigurationPacket;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorBlockEntity;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsGuiTextures;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.Collections;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BrassDepositorScreen
extends AbstractSimiContainerScreen<BrassDepositorMenu> {
    private final NumismaticsGuiTextures background = NumismaticsGuiTextures.BRASS_DEPOSITOR;
    private final ItemStack renderedItem = NumismaticsBlocks.BRASS_DEPOSITOR.asStack();
    private final int COIN_COUNT = Coin.values().length;
    private final Label[] coinLabels = new Label[this.COIN_COUNT];
    private final ScrollInput[] coinScrollInputs = new ScrollInput[this.COIN_COUNT];
    private List<Rect2i> extraAreas = Collections.emptyList();

    public BrassDepositorScreen(BrassDepositorMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.width, this.background.height + 2 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        this.setWindowOffset(-20, 0);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        IconButton trustListButton = new IconButton(x + 7, y + 121, (ScreenElement)AllIcons.I_VIEW_SCHEDULE);
        trustListButton.withCallback(() -> ((BrassDepositorBlockEntity)((BrassDepositorMenu)this.f_97732_).contentHolder).openTrustList());
        this.m_142416_((GuiEventListener)trustListButton);
        IconButton confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> ((BrassDepositorScreen)this).m_7379_());
        this.m_142416_((GuiEventListener)confirmButton);
        for (Coin coin : Coin.values()) {
            int i = coin.ordinal();
            int baseX = x + 36 + (i < 3 ? 0 : 86) + 13;
            int yIncrement = 22;
            int baseY = y + 45 + yIncrement * (i % 3);
            this.coinLabels[i] = new Label(baseX + 18, baseY + 5, CommonComponents.f_237098_).withShadow();
            this.m_142416_((GuiEventListener)this.coinLabels[i]);
            this.coinScrollInputs[i] = new ScrollInput(baseX, baseY, 36, 18).withRange(0, 129).writingTo(this.coinLabels[i]).titled(Component.m_237113_((String)TextUtils.titleCaseConversion(coin.getName(0)))).calling(value -> {
                ((BrassDepositorBlockEntity)((BrassDepositorMenu)this.f_97732_).contentHolder).setPrice(coin, (int)value);
                this.coinLabels[i].m_252865_(baseX + 18 - this.f_96547_.m_92852_((FormattedText)this.coinLabels[i].text) / 2);
            });
            this.m_142416_((GuiEventListener)this.coinScrollInputs[i]);
            this.coinScrollInputs[i].setState(((BrassDepositorBlockEntity)((BrassDepositorMenu)this.f_97732_).contentHolder).getPrice(coin));
            this.coinScrollInputs[i].onChanged();
        }
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background.width, y + this.background.height - 68, 84, 84));
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.f_97736_ + this.background.height + 2;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.background.render(graphics, x, y);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)this.renderedItem).at((float)(x + this.background.width + 6), (float)(y + this.background.height - 70), -200.0f)).scale(5.0).render(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, x + (this.background.width - 8) / 2, y + 3, 0xFFFFFF);
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(((BrassDepositorBlockEntity)((BrassDepositorMenu)this.f_97732_).contentHolder).getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        MutableComponent balanceLabel = Component.m_237110_((String)"block.numismatics.brass_depositor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        graphics.m_280653_(this.f_96547_, (Component)balanceLabel, x + (this.background.width - 8) / 2, y + 21, 0xFFFFFF);
    }

    public void m_7861_() {
        NumismaticsPackets.PACKETS.send(new SliderStylePriceConfigurationPacket((SyncedBlockEntity)((BrassDepositorMenu)this.f_97732_).contentHolder));
        super.m_7861_();
    }
}

