/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.simibubi.create.foundation.gui.menu.MenuBase;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardSlot;
import dev.ithundxr.createnumismatics.content.coins.CoinDisplaySlot;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.SlotDiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.vendor.FilteringSlot;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlockEntity;
import dev.ithundxr.createnumismatics.content.vendor.VendorContainerSynchronizer;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class VendorMenu
extends MenuBase<VendorBlockEntity> {
    public static final int COIN_SLOTS;
    public static final int CARD_SLOT_INDEX;
    public static final int SELLING_SLOT_INDEX;
    public static final int INV_START_INDEX;
    public static final int INV_END_INDEX;
    public static final int PLAYER_INV_START_INDEX;
    public static final int PLAYER_HOTBAR_END_INDEX;
    public static final int PLAYER_INV_END_INDEX;

    public VendorMenu(MenuType<?> type, int id, Inventory inv, FriendlyByteBuf extraData) {
        super(type, id, inv, extraData);
    }

    public VendorMenu(MenuType<?> type, int id, Inventory inv, VendorBlockEntity contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    protected VendorBlockEntity createOnClient(FriendlyByteBuf extraData) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity blockEntity = world.m_7702_(extraData.m_130135_());
        if (blockEntity instanceof VendorBlockEntity) {
            VendorBlockEntity vendorBE = (VendorBlockEntity)blockEntity;
            vendorBE.readClient(extraData.m_130260_());
            return vendorBE;
        }
        return null;
    }

    protected void initAndReadInventory(VendorBlockEntity contentHolder) {
    }

    protected void addSlots() {
        int x = 30;
        int y = 122;
        for (Coin coin : Coin.values()) {
            this.m_38897_(new SlotDiscreteCoinBag(((VendorBlockEntity)this.contentHolder).inventory, coin, x, y, true, true));
            x += 18;
        }
        this.m_38897_(new CardSlot.BoundCardSlot(((VendorBlockEntity)this.contentHolder).cardContainer, 0, 174, y));
        this.m_38897_(new Slot(((VendorBlockEntity)this.contentHolder).sellingContainer, 0, 147, y));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new FilteringSlot((Container)this.contentHolder, j + i * 3, 87 + j * 18, 49 + i * 18 + 11, ((VendorBlockEntity)this.contentHolder)::matchesSellingItem));
            }
        }
        this.addPlayerSlots(58, 165);
        int labelX1 = 12;
        int labelX2 = labelX1 + 86 + 54;
        int labelY = 46;
        int labelYIncrement = 22;
        for (int i = 0; i < 6; ++i) {
            Coin coin = Coin.values()[i];
            int slotX = i < 3 ? labelX1 : labelX2;
            int slotY = labelY + i % 3 * labelYIncrement;
            this.m_38897_(new CoinDisplaySlot(coin, slotX, slotY));
        }
    }

    protected void saveData(VendorBlockEntity contentHolder) {
    }

    public void m_150399_(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        super.m_150399_(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        Slot clickedSlot = this.m_38853_(index);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = clickedSlot.m_7993_();
        if (index < COIN_SLOTS) {
            Item item = stack.m_41720_();
            if (!(item instanceof CoinItem)) {
                return ItemStack.f_41583_;
            }
            CoinItem coinItem = (CoinItem)item;
            Coin coin = coinItem.coin;
            int startCount = stack.m_41613_();
            this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false);
            int diff = startCount - stack.m_41613_();
            if (diff > 0) {
                ((VendorBlockEntity)this.contentHolder).inventory.subtract(coin, diff);
                clickedSlot.m_6654_();
            } else if (diff < 0) {
                ((VendorBlockEntity)this.contentHolder).inventory.add(coin, -diff);
                clickedSlot.m_6654_();
            }
            return ItemStack.f_41583_;
        }
        if (index == CARD_SLOT_INDEX) {
            if (!this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index == SELLING_SLOT_INDEX) {
            if (!this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
        } else if (INV_START_INDEX <= index && index < INV_END_INDEX) {
            if (!this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (stack.m_41720_() instanceof CoinItem && !this.m_38903_(stack, 0, COIN_SLOTS, false)) {
                return ItemStack.f_41583_;
            }
            if (NumismaticsTags.AllItemTags.CARDS.matches(stack) && !this.m_38903_(stack, CARD_SLOT_INDEX, CARD_SLOT_INDEX + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (((VendorBlockEntity)this.contentHolder).sellingContainer.m_7983_() && !this.m_38903_(stack, SELLING_SLOT_INDEX, SELLING_SLOT_INDEX + 1, false)) {
                return ItemStack.f_41583_;
            }
            if (((VendorBlockEntity)this.contentHolder).matchesSellingItem(stack) && !this.m_38903_(stack, INV_START_INDEX, INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= PLAYER_INV_START_INDEX && index < PLAYER_HOTBAR_END_INDEX && !this.m_38903_(stack, PLAYER_HOTBAR_END_INDEX, PLAYER_INV_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            if (index >= PLAYER_HOTBAR_END_INDEX && index < PLAYER_INV_END_INDEX && !this.m_38903_(stack, PLAYER_INV_START_INDEX, PLAYER_HOTBAR_END_INDEX, false)) {
                return ItemStack.f_41583_;
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public void m_150416_(@NotNull ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            super.m_150416_((ContainerSynchronizer)new VendorContainerSynchronizer(serverPlayer));
            return;
        }
        super.m_150416_(synchronizer);
    }

    static {
        CARD_SLOT_INDEX = COIN_SLOTS = Coin.values().length;
        SELLING_SLOT_INDEX = CARD_SLOT_INDEX + 1;
        INV_START_INDEX = SELLING_SLOT_INDEX + 1;
        PLAYER_INV_START_INDEX = INV_END_INDEX = INV_START_INDEX + 9;
        PLAYER_HOTBAR_END_INDEX = PLAYER_INV_START_INDEX + 9;
        PLAYER_INV_END_INDEX = PLAYER_INV_START_INDEX + 36;
    }
}

