/*
 * Decompiled with CFR 0.152.
 */
package net.adeptstack.behaviour.doorBlock;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import net.adeptstack.blocks.doors.slidingDoor.TrainSlidingDoorBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DoorBlockMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        if (!(currentState.m_60734_() instanceof DoorBlock)) {
            return currentState;
        }
        boolean trainDoor = currentState.m_60734_() instanceof TrainSlidingDoorBlock;
        SoundEvent sound = ((Boolean)currentState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue() ? (trainDoor ? null : SoundEvents.f_12626_) : (trainDoor ? SoundEvents.f_12056_ : SoundEvents.f_12627_);
        BlockPos otherPos = currentState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(otherPos);
        if (info.f_74676_().m_61138_((Property)DoorBlock.f_52727_)) {
            BlockState newState = (BlockState)info.f_74676_().m_61122_((Property)DoorBlock.f_52727_);
            this.setContraptionBlockData(contraption.entity, otherPos, new StructureTemplate.StructureBlockInfo(info.f_74675_(), newState, info.f_74677_()));
        }
        currentState = (BlockState)currentState.m_61122_((Property)DoorBlock.f_52727_);
        if (player != null) {
            if (trainDoor) {
                DoorHingeSide hinge = (DoorHingeSide)currentState.m_61143_((Property)TrainSlidingDoorBlock.f_52728_);
                Direction facing = (Direction)currentState.m_61143_((Property)TrainSlidingDoorBlock.f_52726_);
                BlockPos doublePos = pos.m_121945_(hinge == DoorHingeSide.LEFT ? facing.m_122427_() : facing.m_122428_());
                StructureTemplate.StructureBlockInfo doubleInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(doublePos);
                if (doubleInfo != null && TrainSlidingDoorBlock.isDoubleDoor((BlockState)currentState, (DoorHingeSide)hinge, (Direction)facing, (BlockState)doubleInfo.f_74676_())) {
                    this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, doublePos, contraption.entity);
                }
            } else {
                float pitch = player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f;
                if (sound != null) {
                    this.playSound(player, sound, pitch);
                }
            }
        }
        return currentState;
    }

    protected boolean updateColliders() {
        return true;
    }
}

