/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.registry;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.util.CommonCollectors;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.LogMessageAdapter;
import net.minecraftforge.fml.ModLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractRegistry<V extends RegistryEntry<V>>
implements Registry<V> {
    protected static final Marker REGISTRY_DUMP = MarkerManager.getMarker((String)"REGISTRY_DUMP");
    protected static final Comparator<String> STRING_COMPARATOR = Comparator.naturalOrder();
    protected final Class<V> type;
    protected final String name;
    protected final V nullValue;
    protected final boolean clearable;
    protected final Codec<V> getterCodec;
    protected final List<Runnable> onLockRunnables = new LinkedList<Runnable>();
    protected final Comparator<V> comparator = (entry, entryToCompareTo) -> STRING_COMPARATOR.compare(entry.getRegistryName().m_135815_(), entryToCompareTo.getRegistryName().m_135815_());
    protected boolean locked = false;

    protected AbstractRegistry(String name, Class<V> type, V nullValue, boolean clearable) {
        this.type = type;
        this.name = name;
        this.nullValue = ((RegistryEntry)nullValue).nullEntry();
        this.clearable = clearable;
        this.getterCodec = ResourceLocation.f_135803_.comapFlatMap(this::getAsDataResult, RegistryEntry::getRegistryName);
    }

    protected void assertValid(V value) {
        ResourceLocation registryName = ((RegistryEntry)value).getRegistryName();
        if (this.locked) {
            throw new RuntimeException(this.getErrorMessage(value, registryName, " to locked registry "));
        }
        if (this.has(registryName)) {
            throw new RuntimeException(this.getErrorMessage(value, registryName, " that already had a value registered in registry "));
        }
    }

    protected String getErrorMessage(V value, ResourceLocation registryName, String message) {
        return "Tried to register '" + String.valueOf(value) + "' under registry name '" + String.valueOf(registryName) + "' " + message + " '" + this.name + "'.";
    }

    @Override
    @SafeVarargs
    public final void registerAll(V ... values) {
        for (V value : values) {
            this.register(value);
        }
    }

    @Override
    public final Optional<V> getOptional(String registryName) {
        return this.getOptional(ResourceLocation.m_135820_((String)registryName));
    }

    @Override
    public final V get(ResourceLocation registryName) {
        return (V)((RegistryEntry)this.getOptional(registryName).orElse(this.nullValue));
    }

    @Override
    public final V get(String registryName) {
        return this.get(ResourceLocation.m_135820_((String)registryName));
    }

    @Override
    public final DataResult<V> getAsDataResult(ResourceLocation registryName) {
        return this.getOptional(TreeRegistry.processResLoc(registryName)).map(DataResult::success).orElse(DataResult.error(() -> "Could not find " + this.name + " '" + String.valueOf(registryName) + "'."));
    }

    @Override
    public final boolean has(ResourceLocation registryName) {
        return this.getAll().stream().map(RegistryEntry::getRegistryName).anyMatch(arg_0 -> ((ResourceLocation)registryName).equals(arg_0));
    }

    @Override
    public final Optional<V> getOptional(ResourceLocation registryName) {
        return this.getAll().stream().filter(entry -> entry.getRegistryName().equals((Object)registryName)).findFirst();
    }

    @Override
    public final Set<ResourceLocation> getRegistryNames() {
        return this.getAll().stream().map(RegistryEntry::getRegistryName).collect(Collectors.toSet());
    }

    @Override
    public final Class<V> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void lock() {
        this.locked = true;
        this.dump();
        this.onLockRunnables.forEach(Runnable::run);
        this.onLockRunnables.clear();
    }

    @Override
    public final void unlock() {
        this.locked = false;
    }

    @Override
    public final void runOnNextLock(Runnable runnable) {
        this.onLockRunnables.add(runnable);
    }

    @Override
    public final void clear() {
        if (!this.clearable) {
            return;
        }
        this.lock();
        this.clearAll();
    }

    protected abstract void clearAll();

    @Override
    public final Codec<V> getGetterCodec() {
        return this.getterCodec;
    }

    @Override
    public final Runnable generateIfValidRunnable(ResourceLocation registryName, Consumer<V> consumer, Runnable elseRunnable) {
        return () -> {
            if (!((RegistryEntry)this.get(registryName)).ifValid(consumer)) {
                elseRunnable.run();
            }
        };
    }

    @Override
    public void postRegistryEvent() {
        ModLoader.get().postEvent(new RegistryEvent(this));
    }

    @Override
    public final Comparator<V> getComparator() {
        return this.comparator;
    }

    @Override
    public final void dump() {
        LogManager.getLogger().debug(REGISTRY_DUMP, () -> new LogMessageAdapter(builder -> {
            builder.append("Name: ").append(this.name).append('\n');
            this.getAll().stream().sorted(this.comparator).forEach(entry -> builder.append("\tEntry: ").append(entry.getRegistryName()).append(", ").append(entry).append('\n'));
        }));
    }

    @Override
    public final Set<V> getAllFor(String namespace) {
        return this.getAll().stream().filter(entry -> entry.getRegistryName().m_135827_().equals(namespace)).collect(CommonCollectors.toUnmodifiableLinkedSet());
    }

    @Override
    public Stream<V> dataGenerationStream(String namespace) {
        return this.getAllFor(namespace).stream().filter(RegistryEntry::shouldGenerateData);
    }

    @Override
    @Nonnull
    public final Iterator<V> iterator() {
        return this.getAll().iterator();
    }
}

