/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.command;

import com.ferreusveritas.dynamictrees.command.SubCommand;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.item.DendroPotion;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.CommandHelper;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public final class CreateTransformPotionCommand
extends SubCommand {
    @Override
    protected String getName() {
        return "createtransformpotion";
    }

    @Override
    protected int getPermissionLevel() {
        return 2;
    }

    @Override
    public ArgumentBuilder<CommandSourceStack, ?> registerArgument() {
        return CreateTransformPotionCommand.blockPosArgument().then(CreateTransformPotionCommand.transformableSpeciesArgument().executes(context -> this.spawnTransformPotion((CommandSourceStack)context.getSource(), CreateTransformPotionCommand.blockPosArgument((CommandContext<CommandSourceStack>)context), CreateTransformPotionCommand.speciesArgument((CommandContext<CommandSourceStack>)context))));
    }

    private int spawnTransformPotion(CommandSourceStack source, BlockPos pos, Species species) throws CommandSyntaxException {
        if (!species.isTransformable()) {
            throw SPECIES_NOT_TRANSFORMABLE.create((Object)species.getTextComponent());
        }
        DendroPotion dendroPotion = DTRegistries.DENDRO_POTION.get();
        ItemStack dendroPotionStack = new ItemStack((ItemLike)dendroPotion);
        DendroPotion.applyIndexTag(dendroPotionStack, DendroPotion.DendroPotionType.TRANSFORM.getIndex());
        dendroPotion.setTargetSpecies(dendroPotionStack, species);
        ItemUtils.spawnItemStack((Level)source.m_81372_(), pos, dendroPotionStack, true);
        CreateTransformPotionCommand.sendSuccessAndLog(source, (Component)Component.m_237110_((String)"commands.dynamictrees.success.create_transform_potion", (Object[])new Object[]{species.getTextComponent(), CommandHelper.posComponent((Vec3i)pos, ChatFormatting.AQUA)}));
        return 1;
    }
}

