/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.data.provider;

import com.ferreusveritas.dynamictrees.api.GatherDataHelper;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.registry.Registry;
import com.ferreusveritas.dynamictrees.data.provider.DTDataProvider;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.LanguageProvider;

public class DTLangProvider
extends LanguageProvider
implements DTDataProvider {
    private final String modId;
    private final List<Registry<?>> registries;

    public DTLangProvider(PackOutput gen, String modId, Collection<Registry<?>> registries) {
        super(gen, modId, "en_us");
        this.modId = modId;
        this.registries = ImmutableList.copyOf(registries);
    }

    protected void addTranslations() {
        this.registries.forEach(registry -> registry.dataGenerationStream(this.modId).forEach(entry -> entry.generateLangData(this)));
        Generator<DTLangProvider, String> generator = GatherDataHelper.getExtraLangGenerators().get(this.modId);
        if (generator != null) {
            generator.generate(this, "", new Generator.Dependencies());
        }
    }
}

