/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation;

import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.result.JsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.util.ShapeFunctions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class VoxelShapeDeserialiser
implements JsonDeserialiser<VoxelShape> {
    @Override
    public Result<VoxelShape, JsonElement> deserialise(JsonElement input) {
        return JsonResult.forInput(input).mapIfType(String.class, name -> CommonVoxelShapes.SHAPES.getOrDefault(name.toLowerCase(Locale.ENGLISH), Shapes.m_83144_())).elseMapIfType(AABB.class, Shapes::m_83064_).elseMapIfType(JsonArray.class, this::deserialiseArray).elseMapIfType(JsonObject.class, this::deserialiseObject).elseTypeError();
    }

    private VoxelShape deserialiseArray(JsonArray array) throws DeserialisationException {
        VoxelShape shape = Shapes.m_83040_();
        for (JsonElement element : array) {
            shape = Shapes.m_83110_((VoxelShape)((VoxelShape)JsonDeserialisers.AABB.deserialise(element).map(Shapes::m_83064_).orElseThrow()), (VoxelShape)shape);
        }
        return shape;
    }

    private VoxelShape deserialiseObject(JsonObject json) throws DeserialisationException {
        return (VoxelShape)JsonResult.forInput((JsonElement)json).mapIfContains("function", String.class, functionId -> (VoxelShape)ShapeFunctions.calculateShape(functionId, (JsonElement)this.getParametersJson(json)).getOrThrow(true, s -> {})).elseMapIfContains("shapes", JsonArray.class, shapes -> {
            BooleanOp operator = JsonHelper.getOrDefault(json, "operator", BooleanOp.class, BooleanOp.f_82695_);
            return this.deserialiseShapes(operator, (JsonArray)shapes);
        }).elseTypeError().orElseThrow();
    }

    private JsonObject getParametersJson(JsonObject json) {
        return JsonHelper.getOrDefault(json, "parameters", JsonObject.class, new JsonObject());
    }

    private VoxelShape deserialiseShapes(BooleanOp operator, JsonArray shapes) throws DeserialisationException {
        if (shapes.size() < 1) {
            return Shapes.m_83040_();
        }
        VoxelShape shape = this.deserialise(shapes.get(0)).orElseThrow();
        for (int i = 1; i < shapes.size(); ++i) {
            shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)this.deserialise(shapes.get(i)).orElseThrow(), (BooleanOp)operator);
        }
        return shape;
    }
}

