/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.deserialisation.result;

import com.ferreusveritas.dynamictrees.deserialisation.DeserialisationException;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialiser;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.result.AbstractResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.MappedJsonResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.MappedResult;
import com.ferreusveritas.dynamictrees.deserialisation.result.Result;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class JsonResult<T>
extends AbstractResult<T, JsonElement> {
    public JsonResult(JsonElement input, @Nullable T value, @Nullable String error) {
        super(input, value, error);
    }

    public JsonResult(JsonElement input, @Nullable T value, @Nullable String error, List<String> warnings) {
        super(input, value, error, warnings);
    }

    @Override
    public Result<T, JsonElement> removeError() {
        return new JsonResult<Object>((JsonElement)this.input, this.value, null, (List<String>)this.warnings);
    }

    @Override
    public <V> MappedResult<V, JsonElement> map(Result.Mapper<T, V> mapper) {
        try {
            return this.value == null ? MappedJsonResult.mapErrorneous(this) : MappedJsonResult.map(mapper.apply(this.value, this.warnings::add), this);
        }
        catch (DeserialisationException | RuntimeException e) {
            return MappedJsonResult.errorneousMap(e.getMessage(), this);
        }
    }

    @Override
    public <V> MappedResult<V, JsonElement> map(Result.Mapper<T, V> mapper, Predicate<V> validator, String invalidError) {
        if (this.value == null) {
            return MappedJsonResult.mapErrorneous(this);
        }
        try {
            Object value = mapper.apply(this.value, this.warnings::add);
            return validator.test(value) ? MappedJsonResult.map(value, this) : MappedJsonResult.errorneousMap(invalidError.replaceFirst("\\{}", this.value.toString()), this);
        }
        catch (DeserialisationException e) {
            return MappedJsonResult.errorneousMap(e.getMessage(), this);
        }
    }

    @Override
    public <V> MappedResult<V, JsonElement> mapIfValid(Predicate<T> validator, String invalidError, Result.Mapper<T, V> mapper) {
        return this.value == null ? MappedJsonResult.mapErrorneous(this) : (validator.test(this.value) ? this.map(mapper, "Unexpected error occurred. This should not be possible.") : MappedJsonResult.errorneousMap(invalidError.replaceFirst("\\{}", this.value.toString()), this));
    }

    @Override
    public <V, N> MappedResult<N, JsonElement> mapIfType(Class<V> type, Result.Mapper<V, N> mapper) {
        return JsonDeserialisers.getOrThrow(type).deserialise((JsonElement)this.input).map(mapper);
    }

    @Override
    public <E> MappedResult<List<E>, JsonElement> mapToListOfType(Class<E> elementType) {
        return JsonDeserialisers.JSON_ARRAY.deserialise((JsonElement)this.input).map(array -> {
            JsonDeserialiser deserialiser = JsonDeserialisers.getOrThrow(elementType);
            LinkedList list = new LinkedList();
            for (JsonElement element : array) {
                list.add(deserialiser.deserialise(element).orElseThrow());
            }
            return list;
        });
    }

    @Override
    public <V, E> MappedResult<List<E>, JsonElement> mapEachIfArray(Class<V> elementType, Result.Mapper<V, E> mapper) {
        return JsonDeserialisers.JSON_ARRAY.deserialise((JsonElement)this.input).map(array -> {
            JsonDeserialiser deserialiser = JsonDeserialisers.getOrThrow(elementType);
            LinkedList list = new LinkedList();
            for (JsonElement element : array) {
                list.add(mapper.apply(deserialiser.deserialise(element).orElseThrow(), this.warnings::add));
            }
            return list;
        });
    }

    @Override
    public <E, V> MappedResult<V, JsonElement> mapIfContains(String key, Class<E> type, Result.Mapper<E, V> mapper) {
        return JsonDeserialisers.JSON_OBJECT.deserialise((JsonElement)this.input).map(object -> {
            JsonElement element = object.get(key);
            if (element == null) {
                throw new DeserialisationException("No value for key \"" + key + "\".");
            }
            return mapper.apply(JsonDeserialisers.getOrThrow(type).deserialise(element).orElseThrow(), this.warnings::add);
        });
    }

    @Override
    public <E, V> MappedResult<V, JsonElement> mapIfContains(String key, Class<E> type, Result.Mapper<E, V> mapper, V defaultValue) {
        return JsonDeserialisers.JSON_OBJECT.deserialise((JsonElement)this.input).map(object -> {
            JsonElement element = object.get(key);
            if (element == null) {
                return defaultValue;
            }
            return mapper.apply(JsonDeserialisers.getOrThrow(type).deserialise(element).orElseThrow(), this.warnings::add);
        });
    }

    public static JsonResult<JsonElement> forInput(JsonElement input) {
        return new JsonResult<Object>(input, null, null);
    }

    public static <T> JsonResult<T> success(JsonElement json, T value) {
        return new JsonResult<T>(json, value, null);
    }

    public static <T> JsonResult<T> failure(JsonElement json, String error) {
        return JsonResult.failure(json, error, Lists.newArrayList());
    }

    public static <T> JsonResult<T> failure(JsonElement json, String error, List<String> warnings) {
        return new JsonResult<Object>(json, null, error, warnings);
    }

    public static <T> Result<T, JsonElement> from(DataResult<Pair<T, JsonElement>> dataResult, JsonElement input) {
        try {
            return (Result)dataResult.get().mapLeft(pair -> JsonResult.success((JsonElement)pair.getSecond(), pair.getFirst())).orThrow();
        }
        catch (RuntimeException e) {
            return JsonResult.failure(input, e.getMessage());
        }
    }
}

