/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.init;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.cell.CellKit;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEvent;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.worldgen.FeatureCanceller;
import com.ferreusveritas.dynamictrees.block.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.branch.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.block.entity.PottedSaplingBlockEntity;
import com.ferreusveritas.dynamictrees.block.entity.SpeciesBlockEntity;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.cell.CellKits;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entity.LingeringEffectorEntity;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKits;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.item.DendroPotion;
import com.ferreusveritas.dynamictrees.item.DirtBucket;
import com.ferreusveritas.dynamictrees.item.Staff;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.ferreusveritas.dynamictrees.loot.entry.DTLootPoolEntries;
import com.ferreusveritas.dynamictrees.loot.function.DTLootFunctions;
import com.ferreusveritas.dynamictrees.systems.BranchConnectables;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatures;
import com.ferreusveritas.dynamictrees.util.holderset.IncludesExcludesHolderSet;
import com.ferreusveritas.dynamictrees.util.holderset.NameRegexMatchHolderSet;
import com.ferreusveritas.dynamictrees.worldgen.CaveRootedTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.CaveRootedTreePlacement;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.biomemodifiers.AddDynamicTreesBiomeModifier;
import com.ferreusveritas.dynamictrees.worldgen.biomemodifiers.RunFeatureCancellersBiomeModifier;
import com.ferreusveritas.dynamictrees.worldgen.feature.DTReplaceNyliumFungiBlockStateProvider;
import com.ferreusveritas.dynamictrees.worldgen.featurecancellation.FungusFeatureCanceller;
import com.ferreusveritas.dynamictrees.worldgen.featurecancellation.MushroomFeatureCanceller;
import com.ferreusveritas.dynamictrees.worldgen.featurecancellation.TreeFeatureCanceller;
import com.ferreusveritas.dynamictrees.worldgen.structure.DTCancelVanillaTreePoolElement;
import com.ferreusveritas.dynamictrees.worldgen.structure.TreePoolElement;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.HugeFungusConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.HugeMushroomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.holdersets.HolderSetType;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DTRegistries {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"dynamictrees");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"dynamictrees");
    public static final DeferredRegister<PlacementModifierType<?>> PLACEMENT_MODIFIER_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256843_, (String)"dynamictrees");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"dynamictrees");
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"dynamictrees");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"dynamictrees");
    public static final DeferredRegister<HolderSetType> HOLDER_SET_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.HOLDER_SET_TYPES, (String)"dynamictrees");
    public static final DeferredRegister<BlockStateProviderType<?>> BLOCK_STATE_PROVIDER_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256891_, (String)"dynamictrees");
    public static final DeferredRegister<StructurePoolElementType<?>> STRUCTURE_POOL_ELEMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.f_257024_, (String)"dynamictrees");
    public static final LinkedList<Item> CREATIVE_TAB_ITEMS = new LinkedList();
    public static final RegistryObject<CreativeModeTab> DT_CREATIVE_TAB = CREATIVE_MODE_TABS.register("dynamictrees", () -> CreativeModeTab.builder().m_257737_(() -> TreeRegistry.findSpecies(DTTrees.OAK).getSeedStack(1)).m_257941_((Component)Component.m_237115_((String)"itemGroup.dynamictrees")).m_257501_((parameters, output) -> {
        for (DendroPotion.DendroPotionType potion : DendroPotion.DendroPotionType.values()) {
            if (!potion.isActive()) continue;
            output.m_246342_(DendroPotion.applyIndexTag(new ItemStack((ItemLike)DENDRO_POTION.get()), potion.getIndex()));
        }
        CREATIVE_TAB_ITEMS.forEach(e -> output.m_246342_(e.m_7968_()));
    }).m_257652_());
    public static final Supplier<PottedSaplingBlock> POTTED_SAPLING = Suppliers.memoize(PottedSaplingBlock::new);
    public static final Supplier<TrunkShellBlock> TRUNK_SHELL = Suppliers.memoize(TrunkShellBlock::new);
    public static final Supplier<DendroPotion> DENDRO_POTION = Suppliers.memoize(DendroPotion::new);
    public static final Supplier<DirtBucket> DIRT_BUCKET = Suppliers.memoize(DirtBucket::new);
    public static final Supplier<Staff> STAFF = Suppliers.memoize(Staff::new);
    public static final Supplier<EntityType<FallingTreeEntity>> FALLING_TREE = DTRegistries.registerEntity("falling_tree", () -> EntityType.Builder.m_20704_(FallingTreeEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(512).setUpdateInterval(Integer.MAX_VALUE).setCustomClientFactory((spawnEntity, level) -> new FallingTreeEntity((Level)level)));
    public static final Supplier<EntityType<LingeringEffectorEntity>> LINGERING_EFFECTOR = DTRegistries.registerEntity("lingering_effector", () -> EntityType.Builder.m_20704_(LingeringEffectorEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory((spawnEntity, level) -> new LingeringEffectorEntity((Level)level, BlockPos.m_274561_((double)spawnEntity.getPosX(), (double)spawnEntity.getPosY(), (double)spawnEntity.getPosZ()), null)));
    public static BlockEntityType<SpeciesBlockEntity> SPECIES_BLOCK_ENTITY;
    public static BlockEntityType<PottedSaplingBlockEntity> POTTED_SAPLING_BLOCK_ENTITY;
    public static final RegistryObject<PlacementModifierType<CaveRootedTreePlacement>> CAVE_ROOTED_TREE_PLACEMENT_MODIFIER_TYPE;
    public static final RegistryObject<DynamicTreeFeature> DYNAMIC_TREE_FEATURE;
    public static final RegistryObject<CaveRootedTreeFeature> CAVE_ROOTED_TREE_FEATURE;
    public static final RegistryObject<Codec<AddDynamicTreesBiomeModifier>> ADD_DYNAMIC_TREES_BIOME_MODIFIER;
    public static final RegistryObject<Codec<RunFeatureCancellersBiomeModifier>> RUN_FEATURE_CANCELLERS_BIOME_MODIFIER;
    public static final RegistryObject<HolderSetType> INCLUDES_EXCLUDES_HOLDER_SET_TYPE;
    public static final RegistryObject<HolderSetType> NAME_REGEX_MATCH_HOLDER_SET_TYPE;
    public static final RegistryObject<HolderSetType> TAGS_REGEX_MATCH_HOLDER_SET_TYPE;
    public static final RegistryObject<BlockStateProviderType<DTReplaceNyliumFungiBlockStateProvider>> REPLACE_NYLIUM_FUNGI_BLOCK_STATE_PROVIDER_TYPE;
    public static final RegistryObject<StructurePoolElementType<DTCancelVanillaTreePoolElement>> CANCEL_VANILLA_VILLAGE_TREE_STRUCTURE_POOL_ELEMENT_TYPE;
    public static final RegistryObject<StructurePoolElementType<TreePoolElement>> TREE_STRUCTURE_POOL_ELEMENT_TYPE;
    public static final FeatureCanceller TREE_CANCELLER;
    public static final FeatureCanceller ROOTED_TREE_CANCELLER;
    public static final FeatureCanceller FUNGUS_CANCELLER;
    public static final FeatureCanceller MUSHROOM_CANCELLER;
    public static final RegistryObject<SoundEvent> FALLING_TREE_HIT_WATER;
    public static final RegistryObject<SoundEvent> FALLING_TREE_BIG_START;
    public static final RegistryObject<SoundEvent> FALLING_TREE_BIG_END;
    public static final RegistryObject<SoundEvent> FALLING_TREE_MEDIUM_START;
    public static final RegistryObject<SoundEvent> FALLING_TREE_MEDIUM_END;
    public static final RegistryObject<SoundEvent> FALLING_TREE_SMALL_HIT_WATER;
    public static final RegistryObject<SoundEvent> FALLING_TREE_SMALL_END;
    public static final RegistryObject<SoundEvent> FALLING_TREE_SMALL_END_BARE;
    public static final RegistryObject<SoundEvent> FALLING_TREE_FUNGUS_START;
    public static final RegistryObject<SoundEvent> FALLING_TREE_FUNGUS_END;
    public static final RegistryObject<SoundEvent> FALLING_TREE_FUNGUS_SMALL_END;

    public static void setup() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ENTITY_TYPES.register(modBus);
        CREATIVE_MODE_TABS.register(modBus);
        FEATURES.register(modBus);
        PLACEMENT_MODIFIER_TYPES.register(modBus);
        SOUND_EVENTS.register(modBus);
        BIOME_MODIFIER_SERIALIZERS.register(modBus);
        HOLDER_SET_TYPES.register(modBus);
        BLOCK_STATE_PROVIDER_TYPES.register(modBus);
        STRUCTURE_POOL_ELEMENT_TYPES.register(modBus);
        DTLootPoolEntries.LOOT_POOL_ENTRY_TYPES.register(modBus);
        DTLootConditions.LOOT_CONDITION_TYPES.register(modBus);
        DTLootFunctions.LOOT_FUNCTION_TYPES.register(modBus);
        DTRegistries.setupBlocks();
        DTRegistries.setupConnectables();
        DTRegistries.setupItems();
    }

    private static void setupBlocks() {
        RegistryHandler.addBlock(PottedSaplingBlock.REG_NAME, POTTED_SAPLING);
        RegistryHandler.addBlock(DynamicTrees.location("trunk_shell"), TRUNK_SHELL);
    }

    private static void setupConnectables() {
        BranchConnectables.makeBlockConnectable(Blocks.f_50717_, (state, level, pos, side) -> {
            if (side == Direction.DOWN) {
                return 1;
            }
            return 0;
        });
        BranchConnectables.makeBlockConnectable(Blocks.f_50701_, (state, level, pos, side) -> {
            if (side == Direction.DOWN) {
                BlockState branchState = level.m_8055_(pos.m_121945_(Direction.UP));
                BranchBlock branch = TreeHelper.getBranch(branchState);
                if (branch != null) {
                    return Mth.m_14045_((int)(branch.getRadius(branchState) - 1), (int)1, (int)8);
                }
                return 8;
            }
            return 0;
        });
    }

    private static void setupItems() {
        RegistryHandler.addItem(DynamicTrees.location("staff"), STAFF);
        RegistryHandler.addItem(DynamicTrees.location("dirt_bucket"), DIRT_BUCKET);
        RegistryHandler.addItem(DynamicTrees.location("dendro_potion"), DENDRO_POTION);
    }

    private static <T extends Entity> Supplier<EntityType<T>> registerEntity(String name, Supplier<EntityType.Builder<T>> builderSupplier) {
        return ENTITY_TYPES.register(name, () -> ((EntityType.Builder)builderSupplier.get()).m_20712_(name));
    }

    public static void setupTileEntities() {
        Block[] rootyBlocks = (RootyBlock[])SoilProperties.REGISTRY.getAll().stream().map(SoilProperties::getBlock).filter(Optional::isPresent).map(Optional::get).distinct().toArray(RootyBlock[]::new);
        SPECIES_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(SpeciesBlockEntity::new, (Block[])rootyBlocks).m_58966_(null);
        POTTED_SAPLING_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(PottedSaplingBlockEntity::new, (Block[])new Block[]{(Block)POTTED_SAPLING.get()}).m_58966_(null);
    }

    @SubscribeEvent
    public static void onTileEntitiesRegistry(RegisterEvent tileEntityRegistryEvent) {
        tileEntityRegistryEvent.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, registerHelper -> {
            DTRegistries.setupTileEntities();
            registerHelper.register(PottedSaplingBlock.REG_NAME, POTTED_SAPLING_BLOCK_ENTITY);
            registerHelper.register(DynamicTrees.location("tile_entity_species"), SPECIES_BLOCK_ENTITY);
        });
    }

    @SubscribeEvent
    public static void onFeatureCancellerRegistry(RegistryEvent<FeatureCanceller> event) {
        event.getRegistry().registerAll(new FeatureCanceller[]{TREE_CANCELLER, ROOTED_TREE_CANCELLER, FUNGUS_CANCELLER, MUSHROOM_CANCELLER});
    }

    @SubscribeEvent
    public static void onCellKitRegistry(RegistryEvent<CellKit> event) {
        CellKits.register(event.getRegistry());
    }

    @SubscribeEvent
    public static void onGrowthLogicKitRegistry(RegistryEvent<GrowthLogicKit> event) {
        GrowthLogicKits.register(event.getRegistry());
    }

    @SubscribeEvent
    public static void onGenFeatureRegistry(RegistryEvent<GenFeature> event) {
        GenFeatures.register(event.getRegistry());
    }

    private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUND_EVENTS.register(name, () -> SoundEvent.m_262824_((ResourceLocation)DynamicTrees.location(name)));
    }

    static {
        CAVE_ROOTED_TREE_PLACEMENT_MODIFIER_TYPE = PLACEMENT_MODIFIER_TYPES.register("cave_rooted_tree", () -> () -> CaveRootedTreePlacement.CODEC);
        DYNAMIC_TREE_FEATURE = FEATURES.register("tree", DynamicTreeFeature::new);
        CAVE_ROOTED_TREE_FEATURE = FEATURES.register("cave_rooted_tree", CaveRootedTreeFeature::new);
        ADD_DYNAMIC_TREES_BIOME_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("add_dynamic_trees", () -> Codec.unit(AddDynamicTreesBiomeModifier::new));
        RUN_FEATURE_CANCELLERS_BIOME_MODIFIER = BIOME_MODIFIER_SERIALIZERS.register("run_feature_cancellers", () -> Codec.unit(RunFeatureCancellersBiomeModifier::new));
        INCLUDES_EXCLUDES_HOLDER_SET_TYPE = HOLDER_SET_TYPES.register("includes_excludes", () -> IncludesExcludesHolderSet::codec);
        NAME_REGEX_MATCH_HOLDER_SET_TYPE = HOLDER_SET_TYPES.register("name_regex_match", () -> NameRegexMatchHolderSet::codec);
        TAGS_REGEX_MATCH_HOLDER_SET_TYPE = HOLDER_SET_TYPES.register("tags_regex_match", () -> NameRegexMatchHolderSet::codec);
        REPLACE_NYLIUM_FUNGI_BLOCK_STATE_PROVIDER_TYPE = BLOCK_STATE_PROVIDER_TYPES.register("replace_nylium_fungi", () -> new BlockStateProviderType(DTReplaceNyliumFungiBlockStateProvider.CODEC));
        CANCEL_VANILLA_VILLAGE_TREE_STRUCTURE_POOL_ELEMENT_TYPE = STRUCTURE_POOL_ELEMENT_TYPES.register("cancel_vanilla_village_tree_element", () -> () -> DTCancelVanillaTreePoolElement.CODEC);
        TREE_STRUCTURE_POOL_ELEMENT_TYPE = STRUCTURE_POOL_ELEMENT_TYPES.register("tree_pool_element", () -> () -> TreePoolElement.CODEC);
        TREE_CANCELLER = new TreeFeatureCanceller<TreeConfiguration>(DynamicTrees.location("tree"), TreeConfiguration.class);
        ROOTED_TREE_CANCELLER = new TreeFeatureCanceller<RootSystemConfiguration>(DynamicTrees.location("rooted_tree"), RootSystemConfiguration.class);
        FUNGUS_CANCELLER = new FungusFeatureCanceller<HugeFungusConfiguration>(DynamicTrees.location("fungus"), HugeFungusConfiguration.class);
        MUSHROOM_CANCELLER = new MushroomFeatureCanceller<HugeMushroomFeatureConfiguration>(DynamicTrees.location("mushroom"), HugeMushroomFeatureConfiguration.class);
        FALLING_TREE_HIT_WATER = DTRegistries.registerSoundEvent("falling_tree_hit_water");
        FALLING_TREE_BIG_START = DTRegistries.registerSoundEvent("falling_tree_big_start");
        FALLING_TREE_BIG_END = DTRegistries.registerSoundEvent("falling_tree_big_end");
        FALLING_TREE_MEDIUM_START = DTRegistries.registerSoundEvent("falling_tree_medium_start");
        FALLING_TREE_MEDIUM_END = DTRegistries.registerSoundEvent("falling_tree_medium_end");
        FALLING_TREE_SMALL_HIT_WATER = DTRegistries.registerSoundEvent("falling_tree_small_hit_water");
        FALLING_TREE_SMALL_END = DTRegistries.registerSoundEvent("falling_tree_small_end");
        FALLING_TREE_SMALL_END_BARE = DTRegistries.registerSoundEvent("falling_tree_small_end_bare");
        FALLING_TREE_FUNGUS_START = DTRegistries.registerSoundEvent("falling_tree_fungus_start");
        FALLING_TREE_FUNGUS_END = DTRegistries.registerSoundEvent("falling_tree_fungus_end");
        FALLING_TREE_FUNGUS_SMALL_END = DTRegistries.registerSoundEvent("falling_tree_fungus_small_end");
    }
}

