/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.loot.condition;

import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.condition.DTLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public final class VoluntarySeedDropChance
implements LootItemCondition {
    private final float rarity;

    public VoluntarySeedDropChance(float rarity) {
        this.rarity = rarity;
    }

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)DTLootConditions.VOLUNTARY_SEED_DROP_CHANCE.get();
    }

    public boolean test(LootContext context) {
        Float seasonalSeedDropFactor = (Float)context.m_78953_(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR);
        assert (seasonalSeedDropFactor != null);
        return (double)this.rarity * (Double)DTConfigs.VOLUNTARY_SEED_DROP_RATE.get() * (double)seasonalSeedDropFactor.floatValue() > (double)context.m_230907_().m_188501_();
    }

    public static LootItemCondition.Builder voluntarySeedDropChance() {
        return () -> new VoluntarySeedDropChance(1.0f);
    }

    public static LootItemCondition.Builder voluntarySeedDropChance(float rarity) {
        return () -> new VoluntarySeedDropChance(rarity);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<VoluntarySeedDropChance> {
        public void serialize(JsonObject json, VoluntarySeedDropChance value, JsonSerializationContext context) {
            json.addProperty("rarity", (Number)Float.valueOf(value.rarity));
        }

        public VoluntarySeedDropChance deserialize(JsonObject json, JsonDeserializationContext context) {
            return new VoluntarySeedDropChance(GsonHelper.m_13820_((JsonObject)json, (String)"rarity", (float)1.0f));
        }
    }
}

