/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources.loader;

import com.ferreusveritas.dynamictrees.api.resource.loading.preparation.JsonRegistryResourceLoader;
import com.ferreusveritas.dynamictrees.block.GrowableBlock;
import com.ferreusveritas.dynamictrees.deserialisation.JsonDeserialisers;
import com.ferreusveritas.dynamictrees.deserialisation.JsonHelper;
import com.ferreusveritas.dynamictrees.deserialisation.ResourceLocationDeserialiser;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.util.Null;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class PodResourceLoader
extends JsonRegistryResourceLoader<Pod> {
    public PodResourceLoader() {
        super(Pod.REGISTRY, "pods");
    }

    @Override
    public void registerAppliers() {
        this.loadAppliers.register("max_age", Integer.class, Pod::setMaxAge).register("minimum_radius", Integer.class, Pod::setMinRadius).register("maximum_radius", Integer.class, Pod::setMaxRadius);
        this.commonAppliers.register("block_shapes", JsonObject.class, this::readBlockShapes);
        this.gatherDataAppliers.register("item_stack", Item.class, (pod, item) -> pod.setItemStack(new ItemStack((ItemLike)item))).register("drop_count", Integer.class, Pod::setDropCount).register("min_drop_count", Integer.class, Pod::setMinDropCount).register("max_drop_count", Integer.class, Pod::setMaxDropCount);
        this.setupAppliers.register("item_stack", Item.class, (pod, item) -> pod.setItemStack(new ItemStack((ItemLike)item)));
        this.reloadAppliers.register("item_stack", ItemStack.class, Pod::setItemStack).register("can_bone_meal", Boolean.class, Pod::setCanBoneMeal).register("growth_chance", Float.class, Pod::setGrowthChance).register("season_offset", Float.class, Pod::setSeasonOffset).register("flower_hold_period_length", Float.class, Pod::setFlowerHoldPeriodLength).register("min_production_factor", Float.class, Pod::setMinProductionFactor).register("mature_action", GrowableBlock.MatureAction.class, Pod::setMatureAction);
    }

    private void readBlockShapes(Pod pod, JsonObject json) {
        Direction.Plane.HORIZONTAL.m_122557_().forEach(facing -> {
            JsonElement shapeArrayElement = json.get(facing.m_122433_().toLowerCase(Locale.ENGLISH));
            if (!shapeArrayElement.isJsonArray()) {
                return;
            }
            LinkedList shapes = new LinkedList();
            shapeArrayElement.getAsJsonArray().forEach(shapeElement -> JsonDeserialisers.VOXEL_SHAPE.deserialise(shapeElement).ifSuccess(shapes::add));
            pod.setBlockShapes((Direction)facing, shapes.toArray(new VoxelShape[0]));
        });
    }

    @Override
    protected void applyLoadAppliers(JsonRegistryResourceLoader.LoadData loadData, JsonObject json) {
        super.applyLoadAppliers(loadData, json);
        JsonObject propertiesJson = this.getBlockPropertiesJson(json);
        if (propertiesJson == null) {
            this.createBlock((Pod)loadData.getResource(), json);
        } else {
            this.createBlock((Pod)loadData.getResource(), json, propertiesJson);
        }
    }

    @Nullable
    private JsonObject getBlockPropertiesJson(JsonObject json) {
        return Null.applyIfNonnull(json.get("block_properties"), element -> JsonDeserialisers.JSON_OBJECT.deserialise(element).orElse(null));
    }

    private void createBlock(Pod pod, JsonObject json) {
        pod.createBlock(this.getBlockRegistryName(pod, json), pod.getDefaultBlockProperties());
    }

    private void createBlock(Pod pod, JsonObject json, JsonObject propertiesJson) {
        BlockBehaviour.Properties blockProperties = JsonHelper.getBlockProperties(propertiesJson, pod.getDefaultMapColor(), pod::getDefaultBlockProperties, error -> this.logError(pod.getRegistryName(), (String)error), warning -> this.logWarning(pod.getRegistryName(), (String)warning));
        pod.createBlock(this.getBlockRegistryName(pod, json), blockProperties);
    }

    @Nullable
    private ResourceLocation getBlockRegistryName(Pod pod, JsonObject json) {
        return Null.applyIfNonnull(json.get("block_registry_name"), element -> ResourceLocationDeserialiser.create(pod.getRegistryName().m_135827_()).deserialise((JsonElement)element).orElse(null));
    }
}

