/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class JsonMapWrapper
implements Map<String, JsonElement> {
    private final JsonObject jsonObject;

    public JsonMapWrapper(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jsonObject.size() < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof String)) {
            return false;
        }
        return this.jsonObject.has((String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.jsonObject.entrySet().stream().map(Map.Entry::getValue).anyMatch(jsonElement -> jsonElement.equals(value));
    }

    @Override
    @Nullable
    public JsonElement get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.jsonObject.get((String)key);
    }

    @Override
    public JsonElement put(String key, JsonElement value) {
        JsonElement previousElement = this.jsonObject.get(key);
        this.jsonObject.add(key, value);
        return previousElement;
    }

    @Override
    @Nullable
    public JsonElement remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return this.jsonObject.remove((String)key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> m) {
        m.forEach((arg_0, arg_1) -> ((JsonObject)this.jsonObject).add(arg_0, arg_1));
    }

    @Override
    public void clear() {
        this.jsonObject.entrySet().stream().map(Map.Entry::getKey).forEach(arg_0 -> ((JsonObject)this.jsonObject).remove(arg_0));
    }

    @Override
    public Set<String> keySet() {
        return this.jsonObject.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Collection<JsonElement> values() {
        return this.jsonObject.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.jsonObject.entrySet();
    }
}

