/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackModel;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.Supporters;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BackpackLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final BackpackModel BACKPACK_MODEL = new BackpackModel();

    public BackpackLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack((Player)clientPlayer)) {
            ItemStack stack = CapabilityUtils.getWearingBackpack((Player)clientPlayer);
            BackpackLayer.renderBackpackLayer((HumanoidModel)this.m_117386_(), poseStack, bufferIn, packedLightIn, (LivingEntity)clientPlayer, stack);
        }
    }

    public static void renderBackpackLayer(HumanoidModel humanoidModel, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, LivingEntity entity, ItemStack stack) {
        Player player;
        if (!NbtHelper.getOrDefault(stack, "IsVisible", true).booleanValue()) {
            return;
        }
        if (!(stack.m_41720_() instanceof TravelersBackpackItem)) {
            return;
        }
        poseStack.m_85836_();
        BackpackLayer.alignModel(poseStack, humanoidModel, BACKPACK_MODEL, entity);
        BACKPACK_MODEL.render(poseStack, packedLightIn, bufferIn, stack);
        if (entity instanceof Player && Supporters.SUPPORTERS.contains((player = (Player)entity).m_36316_().getName())) {
            BackpackLayer.BACKPACK_MODEL.supporterBadgeModel.render(poseStack, packedLightIn);
        }
        poseStack.m_85849_();
    }

    public static void alignModel(PoseStack poseStack, HumanoidModel parent, BackpackModel backpackModel, LivingEntity entity) {
        backpackModel.copyFrom(parent.f_102810_);
        backpackModel.supporterBadgeModel.copyFrom(parent.f_102810_);
        if (entity.m_6162_()) {
            poseStack.m_252880_(0.0f, 0.8f, -0.165f);
            float scaleFactor = entity.m_6134_();
            poseStack.m_85841_(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }
}

