/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.Window;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.Collections;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class HudOverlay {
    public static final ResourceLocation OVERLAY = new ResourceLocation("travelersbackpack", "textures/gui/overlay.png");
    private static float animationProgress = 0.0f;

    public static void render(GuiGraphics guiGraphics, float partialTicks) {
        if (((Boolean)TravelersBackpackConfig.CLIENT.overlay.enableOverlay.get()).booleanValue() && !Minecraft.m_91087_().f_91066_.f_92062_ && CapabilityUtils.isWearingBackpack((Player)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91072_.m_105295_() != GameType.SPECTATOR) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Window mainWindow = Minecraft.m_91087_().m_91268_();
            ItemStack stack = CapabilityUtils.getWearingBackpack((Player)player);
            int scaledWidth = mainWindow.m_85445_() - (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetX.get();
            int scaledHeight = mainWindow.m_85446_() - (Integer)TravelersBackpackConfig.CLIENT.overlay.offsetY.get();
            int textureX = 10;
            int textureY = 0;
            KeyMapping key = ModClientEventHandler.SWAP_TOOL;
            boolean moveTools = false;
            if (!NbtHelper.getOrDefault(stack, "RenderInfo", RenderInfo.EMPTY).isEmpty()) {
                moveTools = true;
                RenderInfo renderInfo = (RenderInfo)NbtHelper.get(stack, "RenderInfo");
                FluidTank leftTank = new FluidTank(renderInfo.getCapacity());
                leftTank.setFluid(renderInfo.getLeftFluidStack());
                FluidTank rightTank = new FluidTank(renderInfo.getCapacity());
                rightTank.setFluid(renderInfo.getRightFluidStack());
                if (!renderInfo.getRightFluidStack().isEmpty()) {
                    HudOverlay.drawGuiTank(guiGraphics, rightTank, scaledWidth + 1, scaledHeight, 21, 8);
                }
                if (!renderInfo.getLeftFluidStack().isEmpty()) {
                    HudOverlay.drawGuiTank(guiGraphics, leftTank, scaledWidth - 11, scaledHeight, 21, 8);
                }
                if (player != null && player.m_21205_().m_41720_() instanceof HoseItem) {
                    int tank = HoseItem.getHoseTank(player.m_21205_());
                    int selectedTextureX = 0;
                    int selectedTextureY = 0;
                    if (tank == 1) {
                        guiGraphics.m_280218_(OVERLAY, scaledWidth, scaledHeight, textureX, textureY, 10, 23);
                        guiGraphics.m_280218_(OVERLAY, scaledWidth - 12, scaledHeight, selectedTextureX, selectedTextureY, 10, 23);
                    }
                    if (tank == 2) {
                        guiGraphics.m_280218_(OVERLAY, scaledWidth, scaledHeight, selectedTextureX, selectedTextureY, 10, 23);
                        guiGraphics.m_280218_(OVERLAY, scaledWidth - 12, scaledHeight, textureX, textureY, 10, 23);
                    }
                    if (tank == 0) {
                        guiGraphics.m_280218_(OVERLAY, scaledWidth, scaledHeight, textureX, textureY, 10, 23);
                        guiGraphics.m_280218_(OVERLAY, scaledWidth - 12, scaledHeight, textureX, textureY, 10, 23);
                    }
                } else {
                    guiGraphics.m_280218_(OVERLAY, scaledWidth, scaledHeight, textureX, textureY, 10, 23);
                    guiGraphics.m_280218_(OVERLAY, scaledWidth - 12, scaledHeight, textureX, textureY, 10, 23);
                }
            }
            if (NbtHelper.has(stack, "ToolsInventory")) {
                NonNullList<ItemStack> tools = HudOverlay.getTools((NonNullList<ItemStack>)((NonNullList)NbtHelper.get(stack, "ToolsInventory")));
                if (key.m_90857_() && tools.size() > 2) {
                    if (animationProgress < 1.0f) {
                        animationProgress += 0.05f;
                    }
                    for (int i = 0; i < tools.size(); ++i) {
                        HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(i), scaledWidth - (moveTools ? 30 : 0), (int)((float)(scaledHeight + 11) - animationProgress * (float)(i * 15)));
                    }
                } else if (!tools.isEmpty()) {
                    if (animationProgress > 0.0f) {
                        for (int i = 0; i < tools.size(); ++i) {
                            HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(i), scaledWidth - (moveTools ? 30 : 0), (int)((float)(scaledHeight + 11) - animationProgress * (float)(i * 15)));
                        }
                        animationProgress -= 0.05f;
                    } else {
                        if (!((ItemStack)tools.get(0)).m_41619_()) {
                            HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(0), scaledWidth - (moveTools ? 30 : 0), scaledHeight - 4);
                        }
                        if (tools.size() > 1 && !((ItemStack)tools.get(tools.size() - 1)).m_41619_()) {
                            HudOverlay.drawItemStack(guiGraphics, (ItemStack)tools.get(tools.size() - 1), scaledWidth - (moveTools ? 30 : 0), scaledHeight + 11);
                        }
                    }
                }
            }
        }
    }

    public static void drawGuiTank(GuiGraphics guiGraphics, FluidTank tank, int startX, int startY, int height, int width) {
        RenderHelper.renderScreenTank(guiGraphics, tank, startX, startY, 0.0, height, width);
    }

    private static void drawItemStack(GuiGraphics guiGraphics, ItemStack stack, int x, int y) {
        guiGraphics.m_280203_(stack, x, y);
        guiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, stack, x, y);
    }

    public static NonNullList<ItemStack> getTools(NonNullList<ItemStack> inventory) {
        NonNullList tools = NonNullList.m_122779_();
        for (ItemStack itemStack : inventory) {
            if (itemStack.m_41619_()) continue;
            tools.add((Object)itemStack);
        }
        Collections.reverse(tools);
        return tools;
    }
}

