/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.sorter.SortSelector;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ContainerSorter {
    public static final int SORT_BACKPACK = 0;
    public static final int QUICK_STACK = 1;
    public static final int TRANSFER_TO_BACKPACK = 2;
    public static final int TRANSFER_TO_PLAYER = 3;

    public static void selectSort(BackpackWrapper backpackWrapper, Player player, int button, boolean shiftPressed) {
        if (button == 0) {
            ContainerSorter.sortBackpack(backpackWrapper, player, backpackWrapper.getSortType(), shiftPressed);
        } else if (button == 1) {
            ContainerSorter.quickStackToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if (button == 2) {
            ContainerSorter.transferToBackpackNoSort(backpackWrapper, player, shiftPressed);
        } else if (button == 3) {
            ContainerSorter.transferToPlayer(backpackWrapper, player);
        }
    }

    public static void sortBackpack(BackpackWrapper backpackWrapper, Player player, SortSelector.SortType type, boolean shiftPressed) {
        if (shiftPressed) {
            backpackWrapper.setNextSortType();
        } else {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            CustomWrapper storage = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
            for (int i = 0; i < storage.getSlots(); ++i) {
                ContainerSorter.addStackWithMerge(stacks, backpackWrapper.getUnsortableSlots().contains(i) ? ItemStack.f_41583_ : storage.getStackInSlot(i));
            }
            if (!stacks.isEmpty()) {
                stacks.sort(SortSelector.getSortTypeComparator(stacks, type));
            }
            if (stacks.isEmpty()) {
                return;
            }
            int j = 0;
            for (int i = 0; i < storage.getSlots(); ++i) {
                if (backpackWrapper.getUnsortableSlots().contains(i)) continue;
                storage.setStackInSlot(i, j < stacks.size() ? (ItemStack)stacks.get(j) : ItemStack.f_41583_);
                ++j;
            }
        }
    }

    public static void quickStackToBackpackNoSort(BackpackWrapper backpackWrapper, Player player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks = new InvWrapper((Container)player.m_150109_());
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.m_41619_() || backpackWrapper.getScreenID() == 1 && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.m_150109_().f_35977_ : backpackWrapper.getBackpackSlotIndex()))) {
                CustomWrapper storage = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                boolean hasExistingStack = IntStream.range(0, storage.getSlots()).mapToObj(storage::getStackInSlot).filter(existing -> !existing.m_41619_()).anyMatch(existing -> existing.m_41720_() == playerStack.m_41720_());
                if (hasExistingStack) {
                    ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                    for (int j = 0; j < storage.getSlots() && !(ext = storage.insertItem(j, ext, false)).m_41619_(); ++j) {
                    }
                    if (!ext.m_41619_()) {
                        playerStacks.insertItem(i, ext, false);
                    }
                }
            }
            ++i;
        }
    }

    public static void transferToBackpackNoSort(BackpackWrapper backpackWrapper, Player player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks;
        block10: {
            playerStacks = new InvWrapper((Container)player.m_150109_());
            if (backpackWrapper.getMemorySlots().isEmpty()) break block10;
            for (Pair<Integer, Pair<ItemStack, Boolean>> pair : backpackWrapper.getMemorySlots()) {
                int i2;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block11: {
                        ItemStack ext;
                        block12: {
                            ItemStack playerStack = playerStacks.getStackInSlot(i2);
                            if (playerStack.m_41619_() || backpackWrapper.getScreenID() == 1 && i2 == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.m_150109_().f_35977_ : backpackWrapper.getBackpackSlotIndex())) break block11;
                            CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                            ItemStack extSimulate = playerStacks.extractItem(i2, Integer.MAX_VALUE, true);
                            ext = ItemStack.f_41583_;
                            if (!((Boolean)((Pair)pair.getSecond()).getSecond() != false ? ItemStackUtils.isSameItemSameTags((ItemStack)((Pair)pair.getSecond()).getFirst(), extSimulate) : ItemStack.m_41656_((ItemStack)((ItemStack)((Pair)pair.getSecond()).getFirst()), (ItemStack)extSimulate))) break block12;
                            ext = playerStacks.extractItem(i2, Integer.MAX_VALUE, false);
                            ext = wrapper.insertItem((Integer)pair.getFirst(), ext, false);
                            if (ext.m_41619_()) break block11;
                        }
                        if (!ext.m_41619_()) {
                            playerStacks.insertItem(i2, ext, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.m_41619_() || backpackWrapper.getScreenID() == 1 && i == (backpackWrapper.getBackpackSlotIndex() == -1 ? player.m_150109_().f_35977_ : backpackWrapper.getBackpackSlotIndex()))) {
                CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
                ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                for (int j = 0; j < wrapper.getSlots() && !(ext = wrapper.insertItem(j, ext, false)).m_41619_(); ++j) {
                }
                if (!ext.m_41619_()) {
                    playerStacks.insertItem(i, ext, false);
                }
            }
            ++i;
        }
    }

    public static void transferToPlayer(BackpackWrapper backpackWrapper, Player player) {
        InvWrapper playerStacks = new InvWrapper((Container)player.m_150109_());
        CustomWrapper wrapper = new CustomWrapper(backpackWrapper, backpackWrapper.getStorage());
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            ItemStack stack = wrapper.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemStack ext = wrapper.extractItem(i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = playerStacks.insertItem(j, ext, false)).m_41619_(); ++j) {
            }
            if (ext.m_41619_()) continue;
            wrapper.isTransferToPlayer = true;
            wrapper.insertItem(i, ext, false);
            wrapper.isTransferToPlayer = false;
        }
    }

    private static void addStackWithMerge(List<ItemStack> stacks, ItemStack newStack) {
        if (newStack.m_41619_()) {
            return;
        }
        if (newStack.m_41753_() && newStack.m_41613_() != newStack.m_41741_()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ItemStack oldStack = stacks.get(j);
                if (!ContainerSorter.canMergeItems(newStack, oldStack)) continue;
                ContainerSorter.combineStacks(newStack, oldStack);
                if (!oldStack.m_41619_() && oldStack.m_41613_() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(ItemStack stack, ItemStack stack2) {
        if (stack.m_41741_() >= stack.m_41613_() + stack2.m_41613_()) {
            stack.m_41769_(stack2.m_41613_());
            stack2.m_41764_(0);
        }
        int maxInsertAmount = Math.min(stack.m_41741_() - stack.m_41613_(), stack2.m_41613_());
        stack.m_41769_(maxInsertAmount);
        stack2.m_41774_(maxInsertAmount);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41753_() || !stack2.m_41753_()) {
            return false;
        }
        if (stack1.m_41613_() == stack2.m_41741_() || stack2.m_41613_() == stack2.m_41741_()) {
            return false;
        }
        if (stack1.m_41720_() != stack2.m_41720_()) {
            return false;
        }
        if (stack1.m_41773_() != stack2.m_41773_()) {
            return false;
        }
        return ItemStack.m_150942_((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class CustomWrapper
    implements IItemHandlerModifiable {
        public final BackpackWrapper wrapper;
        public final ItemStackHandler parent;
        public boolean isTransferToPlayer;

        public CustomWrapper(BackpackWrapper wrapper, ItemStackHandler parent) {
            this(wrapper, parent, false);
        }

        public CustomWrapper(BackpackWrapper wrapper, ItemStackHandler parent, boolean isTransferToPlayer) {
            this.wrapper = wrapper;
            this.parent = parent;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.parent.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.parent.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (this.wrapper.getMemorizedSlot(slot).isPresent()) {
                return this.wrapper.getMemorySlots().stream().noneMatch(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        return (Integer)pair.getFirst() == slot && ItemStackUtils.isSameItemSameTags((ItemStack)((Pair)pair.getSecond()).getFirst(), stack);
                    }
                    return (Integer)pair.getFirst() == slot && ItemStack.m_41656_((ItemStack)((ItemStack)((Pair)pair.getSecond()).getFirst()), (ItemStack)stack);
                }) ? stack : this.parent.insertItem(slot, stack, simulate);
            }
            return this.wrapper.getUnsortableSlots().contains(slot) ? stack : this.parent.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapper.getUnsortableSlots().contains(slot) ? ItemStack.f_41583_ : this.parent.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.parent.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.parent.isItemValid(slot, stack);
        }
    }
}

