/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.smelting;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.IMoveSelector;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.smelting.AbstractSmeltingWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractSmeltingUpgrade<T>
extends UpgradeBase<T>
implements IEnable,
ITickableUpgrade,
IMoveSelector {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    private final Level level;
    protected ItemStackHandler items;
    private AbstractCookingRecipe cachedRecipe = null;
    private boolean recipeFetched = false;
    private final RecipeType<? extends AbstractCookingRecipe> recipeType;
    private final RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> quickCheck;
    private final String upgradeName;

    public AbstractSmeltingUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> furnaceContents, RecipeType<? extends AbstractCookingRecipe> recipeType, String upgradeName) {
        super(manager, dataHolderSlot, new Point(66, 82));
        this.level = manager.getWrapper().getLevel();
        this.items = this.createHandler(furnaceContents);
        this.recipeType = recipeType;
        this.quickCheck = RecipeManager.m_220267_(this.recipeType);
        this.upgradeName = upgradeName;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new AbstractSmeltingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y), "screen.travelersbackpack." + this.upgradeName);
    }

    @Override
    public void onUpgradeRemoved(ItemStack removedStack) {
        NbtHelper.remove(removedStack, "CookingTotalTime");
        NbtHelper.remove(removedStack, "CookingFinishTime");
        NbtHelper.remove(removedStack, "BurnTotalTime");
        NbtHelper.remove(removedStack, "BurnFinishTime");
    }

    @Override
    public List<Slot> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        slots.add((Slot)new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, (IItemHandler)this.items, 0, x + 7, y + 23));
        slots.add((Slot)new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, (IItemHandler)this.items, 1, x + 7, y + 23 + 36));
        slots.add((Slot)new UpgradeSlotItemHandler<AbstractSmeltingUpgrade>(this, (IItemHandler)this.items, 2, x + 7 + 18 + 18, y + 23 + 18));
        return slots;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.stopCooking();
            this.stopBurning();
        } else {
            this.checkCooking(this.level, false);
        }
    }

    @Override
    public void tick(@Nullable Player player, Level level, BlockPos pos, int currentTick) {
        if (level.f_46443_ || !this.isEnabled(this)) {
            return;
        }
        long currentTime = level.m_46467_();
        if (this.isBurning()) {
            if (this.isCooking() && currentTime >= this.getCookingFinishTime()) {
                this.finishCooking();
            }
            if (currentTime >= this.getBurnFinishTime()) {
                this.finishBurning();
            }
        }
        if (player != null && player.f_36096_ instanceof BackpackBaseMenu) {
            this.tickSmelting(level);
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    @Override
    public int getTickRate() {
        return 5;
    }

    public boolean isFuel(ItemStack pStack) {
        return ForgeHooks.getBurnTime((ItemStack)pStack, null) > 0;
    }

    public boolean isBurning() {
        return this.getBurnFinishTime() > 0L;
    }

    public boolean isCooking() {
        return this.getCookingFinishTime() > 0L;
    }

    public boolean hasFuel() {
        return !this.getStack(1).m_41619_() && this.isFuel(this.getStack(1)) || this.isBurning();
    }

    public void tickSmelting(Level level) {
        if (!this.recipeFetched && this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.m_213657_((Container)new RecipeWrapper((IItemHandlerModifiable)this.items), level).orElse(null);
            this.recipeFetched = true;
        }
        boolean shouldStop = false;
        if (this.isCooking() && this.isBurning()) {
            if (this.cachedRecipe != null) {
                AbstractCookingRecipe currentRecipe = this.quickCheck.m_213657_((Container)new RecipeWrapper((IItemHandlerModifiable)this.items), level).orElse(null);
                if (this.cachedRecipe != currentRecipe) {
                    this.cachedRecipe = currentRecipe;
                    shouldStop = true;
                }
            } else {
                shouldStop = true;
            }
        }
        if (shouldStop) {
            this.stopCooking();
            this.checkCooking(level, false);
        }
    }

    public void checkCooking(Level level, boolean force) {
        if (level.f_46443_ || !this.isEnabled(this)) {
            return;
        }
        if (this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.m_213657_((Container)new RecipeWrapper((IItemHandlerModifiable)this.items), level).orElse(null);
        }
        if ((force || !this.isCooking()) && this.canBurn(this.cachedRecipe)) {
            if (!this.isBurning()) {
                this.startBurning();
            }
            this.startCooking(this.cachedRecipe);
        }
    }

    public void startCooking(AbstractCookingRecipe recipe) {
        int cookingDuration = recipe.m_43753_();
        this.setCookingFinishTime(this.level.m_46467_() + (long)cookingDuration);
        this.setCookingTotalTime(cookingDuration);
    }

    public void startBurning() {
        int litDuration = this.getBurnDuration(this.getStack(1));
        this.setBurnFinishTime(this.level.m_46467_() + (long)litDuration);
        this.setBurnTotalTime(litDuration);
        this.shrinkFuelSlot();
    }

    private boolean canBurn(@Nullable AbstractCookingRecipe recipe) {
        if (!this.getStack(0).m_41619_() && recipe != null && this.hasFuel()) {
            ItemStack cookingResult = recipe.m_5874_((Container)new RecipeWrapper((IItemHandlerModifiable)this.items), this.level.m_9598_());
            if (cookingResult.m_41619_()) {
                return false;
            }
            ItemStack resultSlotStack = this.getStack(2);
            if (resultSlotStack.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)resultSlotStack, (ItemStack)cookingResult)) {
                return false;
            }
            if (resultSlotStack.m_41613_() + cookingResult.m_41613_() <= this.items.getSlotLimit(2) && resultSlotStack.m_41613_() + cookingResult.m_41613_() <= resultSlotStack.m_41741_()) {
                return true;
            }
            return resultSlotStack.m_41613_() + cookingResult.m_41613_() <= cookingResult.m_41741_();
        }
        return false;
    }

    public void finishCooking() {
        if (this.cachedRecipe == null) {
            this.cachedRecipe = this.quickCheck.m_213657_((Container)new RecipeWrapper((IItemHandlerModifiable)this.items), this.level).orElse(null);
        }
        if (this.cachedRecipe != null) {
            ItemStack result = this.cachedRecipe.m_5874_((Container)new RecipeWrapper((IItemHandlerModifiable)this.items), this.level.m_9598_());
            ItemStack input = this.getStack(0).m_41777_();
            ItemStack resultSlot = this.getStack(2).m_41777_();
            if (!resultSlot.m_41619_()) {
                resultSlot.m_41769_(1);
            } else {
                resultSlot = result;
            }
            if (input.m_150930_(Blocks.f_50057_.m_5456_()) && !this.getStack(1).m_41619_() && this.getStack(1).m_150930_(Items.f_42446_)) {
                this.setStack(1, new ItemStack((ItemLike)Items.f_42447_));
            }
            input.m_41774_(1);
            this.setStack(0, input);
            this.setStack(2, resultSlot);
        }
        if (this.canBurn(this.cachedRecipe)) {
            this.checkCooking(this.level, true);
        } else {
            this.stopCooking();
        }
    }

    public void shrinkFuelSlot() {
        ItemStack fuel = this.getStack(1).m_41777_();
        if (fuel.hasCraftingRemainingItem()) {
            this.setStack(1, fuel.getCraftingRemainingItem());
        } else {
            fuel.m_41774_(1);
            this.setStack(1, fuel);
        }
    }

    public void finishBurning() {
        ItemStack fuel = this.getStack(1).m_41777_();
        if (this.isFuel(fuel) && this.isCooking()) {
            this.startBurning();
        } else {
            this.stopCooking();
            this.stopBurning();
            this.cachedRecipe = null;
        }
    }

    public void setStack(int slot, ItemStack stack) {
        this.items.setStackInSlot(slot, stack);
    }

    public ItemStack getStack(int slot) {
        return this.items.getStackInSlot(slot);
    }

    protected int getBurnDuration(ItemStack pFuel) {
        if (pFuel.m_41619_()) {
            return 0;
        }
        return ForgeHooks.getBurnTime((ItemStack)pFuel, this.recipeType);
    }

    public int getBurnTotalTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "BurnTotalTime", 0);
    }

    public long getBurnFinishTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "BurnFinishTime", 0L);
    }

    public int getCookingTotalTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "CookingTotalTime", 0);
    }

    public long getCookingFinishTime() {
        return NbtHelper.getOrDefault(this.getDataHolderStack(), "CookingFinishTime", 0L);
    }

    public void setBurnTotalTime(int time) {
        this.setStackData("BurnTotalTime", time);
    }

    public void setBurnFinishTime(long time) {
        this.setStackData("BurnFinishTime", time);
    }

    public void setCookingTotalTime(int time) {
        this.setStackData("CookingTotalTime", time);
    }

    public void setCookingFinishTime(long time) {
        this.setStackData("CookingFinishTime", time);
    }

    public void stopCooking() {
        this.setCookingFinishTime(0L);
        this.setCookingTotalTime(0);
    }

    public void stopBurning() {
        this.setBurnFinishTime(0L);
        this.setBurnTotalTime(0);
    }

    public void setSlotChanged(ItemStack dataHolderStack, int index, ItemStack stack) {
        NbtHelper.update(dataHolderStack, "Inventory", 3, index, stack);
    }

    public void setStackData(String data, Object value) {
        ItemStack stack = this.getDataHolderStack().m_41777_();
        if (value == null) {
            NbtHelper.remove(stack, data);
        } else {
            NbtHelper.set(stack, data, value);
        }
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), stack);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                AbstractSmeltingUpgrade.this.updateDataHolderUnchecked(dataHolderStack -> AbstractSmeltingUpgrade.this.setSlotChanged((ItemStack)dataHolderStack, slot, this.getStackInSlot(slot)));
                if (AbstractSmeltingUpgrade.this.getUpgradeManager().getWrapper().getScreenID() == 2) {
                    AbstractSmeltingUpgrade.this.checkCooking(AbstractSmeltingUpgrade.this.level, false);
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot == 0) {
                    return BackpackSlotItemHandler.isItemValid(stack);
                }
                if (slot == 1) {
                    ItemStack fuel = AbstractSmeltingUpgrade.this.getStack(1);
                    return ForgeHooks.getBurnTime((ItemStack)stack, AbstractSmeltingUpgrade.this.recipeType) > 0 || stack.m_150930_(Items.f_42446_) && !fuel.m_150930_(Items.f_42446_);
                }
                return false;
            }

            protected int getStackLimit(int slot, @NotNull ItemStack stack) {
                if (slot == 1 && stack.m_150930_(Items.f_42446_)) {
                    return 1;
                }
                return super.getStackLimit(slot, stack);
            }
        };
    }
}

