/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannons.autocannon.recoil_spring;

import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import rbasamoyai.createbigcannons.cannons.autocannon.AutocannonBlock;
import rbasamoyai.createbigcannons.cannons.autocannon.recoil_spring.AutocannonRecoilSpringBlockEntity;
import rbasamoyai.createbigcannons.index.CBCBlockPartials;

public class AutocannonRecoilSpringVisual
extends AbstractBlockEntityVisual<AutocannonRecoilSpringBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance spring;
    private final Map<BlockPos, OrientedInstance> blocks = new HashMap<BlockPos, OrientedInstance>();
    private final Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);

    public AutocannonRecoilSpringVisual(VisualizationContext ctx, AutocannonRecoilSpringBlockEntity blockEntity, float partialTicks) {
        super(ctx, (BlockEntity)blockEntity, partialTicks);
        this.spring = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getPartialModelForState(), (Direction)this.facing)).createInstance();
        this.blocks.clear();
        for (Map.Entry<BlockPos, BlockState> entry : ((AutocannonRecoilSpringBlockEntity)this.blockEntity).toAnimate.entrySet()) {
            if (entry.getValue() == null) continue;
            this.blocks.put(entry.getKey(), (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.block((BlockState)entry.getValue())).createInstance());
        }
        this.updateTransforms(partialTicks);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        this.updateTransforms(ctx.partialTick());
    }

    private void updateTransforms(float partialTicks) {
        boolean flag = this.facing.m_122421_() == Direction.AxisDirection.NEGATIVE;
        BlockPos pos = this.getVisualPosition().m_5484_(this.facing.m_122424_(), flag ? 1 : 0);
        Vec3 pivot = Vec3.m_82528_((Vec3i)pos);
        float scale = ((AutocannonRecoilSpringBlockEntity)this.blockEntity).getAnimateOffset(partialTicks);
        float f1 = scale * 0.5f + 0.5f;
        Direction.Axis axis = this.facing.m_122434_();
        float fx = axis == Direction.Axis.X ? f1 : 1.0f;
        float fy = axis == Direction.Axis.Y ? f1 : 1.0f;
        float fz = axis == Direction.Axis.Z ? f1 : 1.0f;
        this.spring.setIdentityTransform().translate(pivot);
        if (flag) {
            ((TransformedInstance)this.spring.rotateCentered((float)Math.PI, axis.m_122478_() ? Direction.EAST : Direction.UP)).translate((Vector3fc)this.facing.m_122424_().m_253071_());
        }
        this.spring.scale(fx, fy, fz);
        this.spring.setChanged();
        Vector3f offs = this.facing.m_253071_();
        offs.mul((1.0f - scale) * -0.5f);
        offs.add((float)this.getVisualPosition().m_123341_(), (float)this.getVisualPosition().m_123342_(), (float)this.getVisualPosition().m_123343_());
        for (Map.Entry<BlockPos, OrientedInstance> entry : this.blocks.entrySet()) {
            BlockPos pos1 = entry.getKey();
            entry.getValue().position((Vector3fc)offs).translatePosition((float)pos1.m_123341_(), (float)pos1.m_123342_(), (float)pos1.m_123343_()).setChanged();
        }
    }

    public void updateLight(float partialTicks) {
        this.relight(this.pos, new FlatLit[]{this.spring});
        for (Map.Entry<BlockPos, OrientedInstance> entry : this.blocks.entrySet()) {
            this.relight(this.pos.m_121955_((Vec3i)entry.getKey()), new FlatLit[]{(FlatLit)entry.getValue()});
        }
    }

    protected void _delete() {
        this.spring.delete();
        for (OrientedInstance block : this.blocks.values()) {
            block.delete();
        }
    }

    private PartialModel getPartialModelForState() {
        PartialModel partialModel;
        Block block = this.blockState.m_60734_();
        if (block instanceof AutocannonBlock) {
            AutocannonBlock cBlock = (AutocannonBlock)block;
            partialModel = CBCBlockPartials.autocannonSpringFor(cBlock.getAutocannonMaterial());
        } else {
            partialModel = CBCBlockPartials.CAST_IRON_AUTOCANNON_SPRING;
        }
        return partialModel;
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.spring);
    }
}

