/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.client.render.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.thatpreston.mermod.client.render.TailStyle;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class TailModel
extends ListModel<Player> {
    private final ModelPart main;
    private final ModelPart bra;
    private final ModelPart waist;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart tail3;
    private final ModelPart tail4;
    private final ModelPart tail5;
    private final ModelPart tail6;
    private final ModelPart tail7;
    private final ModelPart fin;

    public TailModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.bra = this.main.m_171324_("bra");
        this.waist = this.main.m_171324_("waist");
        this.tail1 = this.waist.m_171324_("tail1");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.tail3 = this.tail2.m_171324_("tail3");
        this.tail4 = this.tail3.m_171324_("tail4");
        this.tail5 = this.tail4.m_171324_("tail5");
        this.tail6 = this.tail5.m_171324_("tail6");
        this.tail7 = this.tail6.m_171324_("tail7");
        this.fin = this.tail7.m_171324_("fin");
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of();
    }

    public void copyFrom(HumanoidModel<?> model) {
        this.main.m_104315_(model.f_102810_);
    }

    public static float getAngle(float x, float speed, float scale) {
        return Mth.m_14031_((float)((float)Math.PI * 2 * x * speed)) * scale;
    }

    public static float getAngleWithOffset(float x, float offset, float speed, float scale) {
        return Mth.m_14031_((float)((float)Math.PI * 2 * (x + offset * (1.0f / speed)) * speed)) * scale;
    }

    public void setupAnim(Player player, float limbSwing, float limbSwingAmount, float age, float yaw, float pitch) {
        boolean swimming;
        boolean crouching = player.m_6047_();
        boolean bl = swimming = player.m_6069_() || player.m_20069_() && !player.m_20096_() && !crouching;
        if (player.m_20202_() != null) {
            float x;
            this.tail1.f_104203_ = -1.5707964f;
            this.tail2.f_104203_ = 0.0f;
            this.tail6.f_104203_ = this.tail7.f_104203_ = (x = 0.02094395f * (Mth.m_14031_((float)(age / 12.0f)) + 3.0f));
            this.tail5.f_104203_ = this.tail7.f_104203_;
            this.tail4.f_104203_ = this.tail7.f_104203_;
            this.tail3.f_104203_ = this.tail7.f_104203_;
            this.fin.f_104203_ = x * 2.0f;
        } else if (swimming) {
            float speed = 0.035f;
            float scale = 0.2617994f;
            this.tail1.f_104203_ = TailModel.getAngle(age, speed, scale);
            this.tail2.f_104203_ = TailModel.getAngleWithOffset(age, -0.1f, speed, scale);
            this.tail3.f_104203_ = TailModel.getAngleWithOffset(age, -0.2f, speed, scale);
            this.tail4.f_104203_ = TailModel.getAngleWithOffset(age, -0.3f, speed, scale);
            this.tail5.f_104203_ = TailModel.getAngleWithOffset(age, -0.4f, speed, scale);
            this.tail6.f_104203_ = TailModel.getAngleWithOffset(age, -0.5f, speed, scale);
            this.tail7.f_104203_ = TailModel.getAngleWithOffset(age, -0.6f, speed, scale);
            this.fin.f_104203_ = this.tail7.f_104203_ * 2.0f;
        } else if (player.m_6067_()) {
            this.fin.f_104203_ = 0.0f;
            this.tail7.f_104203_ = 0.0f;
            this.tail6.f_104203_ = 0.0f;
            this.tail5.f_104203_ = 0.0f;
            this.tail4.f_104203_ = 0.0f;
            this.tail3.f_104203_ = 0.0f;
            this.tail2.f_104203_ = 0.0f;
            this.tail1.f_104203_ = 0.0f;
        } else {
            float angle;
            this.tail7.f_104203_ = this.fin.f_104203_ = (angle = crouching ? 0.19634955f : 0.22439948f);
            this.tail6.f_104203_ = this.fin.f_104203_;
            this.tail5.f_104203_ = this.fin.f_104203_;
            this.tail4.f_104203_ = this.fin.f_104203_;
            this.tail3.f_104203_ = this.fin.f_104203_;
            this.tail2.f_104203_ = this.fin.f_104203_;
            this.tail1.f_104203_ = this.fin.f_104203_;
        }
    }

    public void render(PoseStack stack, VertexConsumer consumer, int light, int overlay, TailStyle style) {
        float tailRed = (float)(style.tailColor() >> 16 & 0xFF) / 255.0f;
        float tailGreen = (float)(style.tailColor() >> 8 & 0xFF) / 255.0f;
        float tailBlue = (float)(style.tailColor() & 0xFF) / 255.0f;
        float braRed = (float)(style.braColor() >> 16 & 0xFF) / 255.0f;
        float braGreen = (float)(style.braColor() >> 8 & 0xFF) / 255.0f;
        float braBlue = (float)(style.braColor() & 0xFF) / 255.0f;
        float gradientRed = (float)(style.gradientColor() >> 16 & 0xFF) / 255.0f;
        float gradientGreen = (float)(style.gradientColor() >> 8 & 0xFF) / 255.0f;
        float gradientBlue = (float)(style.gradientColor() & 0xFF) / 255.0f;
        this.main.m_104299_(stack);
        if (style.hasBra()) {
            this.bra.m_104306_(stack, consumer, light, overlay, braRed, braGreen, braBlue, 1.0f);
        }
        AtomicInteger index = new AtomicInteger();
        this.waist.m_171309_(stack, (entry, path, cuboidIndex, cuboid) -> {
            float red = tailRed;
            float green = tailGreen;
            float blue = tailBlue;
            if (style.hasGradient()) {
                if (path.endsWith("fin") || path.endsWith("sidefins")) {
                    red = gradientRed;
                    green = gradientGreen;
                    blue = gradientBlue;
                } else {
                    float alpha = (float)index.get() / 8.0f;
                    red = Mth.m_14179_((float)alpha, (float)red, (float)gradientRed);
                    green = Mth.m_14179_((float)alpha, (float)green, (float)gradientGreen);
                    blue = Mth.m_14179_((float)alpha, (float)blue, (float)gradientBlue);
                    index.getAndIncrement();
                }
            }
            cuboid.m_171332_(entry, consumer, light, overlay, red, green, blue, 1.0f);
        });
    }
}

