/*
 * Decompiled with CFR 0.152.
 */
package io.github.thatpreston.mermod.recipe;

import io.github.thatpreston.mermod.item.SeaNecklaceItem;
import io.github.thatpreston.mermod.item.modifier.NecklaceModifierItem;
import io.github.thatpreston.mermod.registry.RegistryHandler;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class NecklaceModifierRecipe
extends CustomRecipe {
    public NecklaceModifierRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        ItemStack necklace = null;
        ArrayList<ItemStack> modifiers = new ArrayList<ItemStack>();
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof SeaNecklaceItem) {
                if (necklace != null) {
                    return false;
                }
                necklace = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof NecklaceModifierItem)) {
                return false;
            }
            modifiers.add(stack);
        }
        return necklace != null && !modifiers.isEmpty() && SeaNecklaceItem.canAddModifiers(necklace, modifiers);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        ArrayList<ItemStack> modifiers = new ArrayList<ItemStack>();
        ItemStack necklace = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof SeaNecklaceItem) {
                if (necklace != null) {
                    return ItemStack.f_41583_;
                }
                necklace = stack.m_41777_();
                continue;
            }
            if (!(stack.m_41720_() instanceof NecklaceModifierItem)) {
                return ItemStack.f_41583_;
            }
            modifiers.add(stack);
        }
        if (necklace != null && !modifiers.isEmpty()) {
            SeaNecklaceItem.addModifiers(necklace, modifiers);
            return necklace;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RegistryHandler.NECKLACE_MODIFIER_SERIALIZER.get();
    }
}

