/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy;

import com.mojang.logging.LogUtils;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.slf4j.Logger;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlockEntities;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyFeatures;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyItems;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyPotPatterns;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.content.blocks.AriaMushroomBlock;
import uwu.juni.wetland_whimsy.content.blocks.BloodcapMushroomBlock;
import uwu.juni.wetland_whimsy.content.blocks.BouncyMushroomBlock;
import uwu.juni.wetland_whimsy.content.blocks.CordgrassBlock;
import uwu.juni.wetland_whimsy.content.blocks.PennywortBlock;
import uwu.juni.wetland_whimsy.data.Datagen;
import uwu.juni.wetland_whimsy.misc.Compat;
import uwu.juni.wetland_whimsy.misc.Creative;
import uwu.juni.wetland_whimsy.misc.WetlandWhimsyConfig;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyWoodTypes;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyBiomeModifiers;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyFoliagePlacers;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTreeDecorators;
import uwu.juni.wetland_whimsy.worldgen.WetlandWhimsyTrunkPlacers;

@Mod(value="wetland_whimsy")
public class WetlandWhimsy {
    public static final String MODID = "wetland_whimsy";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("wetland_whimsy");
    private static final DeferredRegister<?>[] REGISTRIES = new DeferredRegister[]{WetlandWhimsyBlocks.BLOCKS, WetlandWhimsyBlockEntities.BLOCK_ENTITIES, WetlandWhimsyEntityTypes.ENTITIES, WetlandWhimsyFeatures.FEATURES, WetlandWhimsyItems.ITEMS, WetlandWhimsyParticleTypes.PARTICLE_TYPES, WetlandWhimsyPotPatterns.PATTERNS, WetlandWhimsySounds.SOUNDS, WetlandWhimsyTreeDecorators.TREE_DECORATORS, WetlandWhimsyFoliagePlacers.FOLIAGE_PLACERS, WetlandWhimsyTrunkPlacers.TRUNK_PLACERS, WetlandWhimsyBiomeModifiers.BIOME_MODIFIERS};
    public static WetlandWhimsyConfig config;

    public WetlandWhimsy() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        LOGGER.info("Whimsical");
        AutoConfig.register(WetlandWhimsyConfig.class, Toml4jConfigSerializer::new);
        config = (WetlandWhimsyConfig)AutoConfig.getConfigHolder(WetlandWhimsyConfig.class).getConfig();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(Datagen::datagen);
        modEventBus.addListener(Creative::addCreative);
        modEventBus.addListener(WetlandWhimsyBlockEntities::blockEntityRendering);
        REGISTRY_HELPER.register(modEventBus);
        for (DeferredRegister<?> registry : REGISTRIES) {
            registry.register(modEventBus);
        }
        WetlandWhimsyBlocks.createSignItems();
        WetlandWhimsyWoodTypes.registerWoodTypes();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> (Screen)AutoConfig.getConfigScreen(WetlandWhimsyConfig.class, (Screen)screen).get()));
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.compat();
        event.enqueueWork(() -> {
            this.compost();
            WetlandWhimsyPotPatterns.initPotPatterns();
        });
    }

    private void compost() {
        ComposterBlock.f_51914_.put((Object)((PennywortBlock)((Object)WetlandWhimsyBlocks.PENNYWORT.get())).m_5456_(), 0.15f);
        ComposterBlock.f_51914_.put((Object)((CordgrassBlock)((Object)WetlandWhimsyBlocks.CORDGRASS.get())).m_5456_(), 0.4f);
        ComposterBlock.f_51914_.put((Object)((Block)WetlandWhimsyBlocks.CORDGRASS_THATCH.get()).m_5456_(), 0.9f);
        ComposterBlock.f_51914_.put((Object)((LeavesBlock)WetlandWhimsyBlocks.BALD_CYPRESS_LEAVES.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((SaplingBlock)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()).m_5456_(), 0.3f);
        ComposterBlock.f_51914_.put((Object)((BloodcapMushroomBlock)((Object)WetlandWhimsyBlocks.BLOODCAP_MUSHROOM.get())).m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)((AriaMushroomBlock)((Object)WetlandWhimsyBlocks.ARIA_MUSHROOM.get())).m_5456_(), 0.65f);
        ComposterBlock.f_51914_.put((Object)((BouncyMushroomBlock)((Object)WetlandWhimsyBlocks.ARIA_MUSHROOM_BLOCK.get())).m_5456_(), 0.85f);
        ComposterBlock.f_51914_.put((Object)((BouncyMushroomBlock)((Object)WetlandWhimsyBlocks.BLOODCAP_MUSHROOM_BLOCK.get())).m_5456_(), 0.85f);
        ComposterBlock.f_51914_.put((Object)((SaplingBlock)WetlandWhimsyBlocks.ARIA_SPORES.get()).m_5456_(), 0.2f);
    }

    private void compat() {
        if (Compat.SUPPLEMENTARIES) {
            ResourceLocation cordgrass_rl = WetlandWhimsy.rLoc("block/compat/cordgrass_box");
            ResourceLocation pennywort_rl = WetlandWhimsy.rLoc("block/compat/pennywort_box");
            ResourceLocation aria_rl = WetlandWhimsy.rLoc("block/compat/aria_box");
            FlowerPotHandler.CUSTOM_MODELS.add(cordgrass_rl);
            FlowerPotHandler.registerCustomSimpleFlower((Item)((CordgrassBlock)((Object)WetlandWhimsyBlocks.CORDGRASS.get())).m_5456_(), (ResourceLocation)cordgrass_rl);
            FlowerPotHandler.CUSTOM_MODELS.add(pennywort_rl);
            FlowerPotHandler.registerCustomSimpleFlower((Item)((PennywortBlock)((Object)WetlandWhimsyBlocks.PENNYWORT.get())).m_5456_(), (ResourceLocation)pennywort_rl);
            FlowerPotHandler.CUSTOM_MODELS.add(aria_rl);
            FlowerPotHandler.registerCustomSimpleFlower((Item)((AriaMushroomBlock)((Object)WetlandWhimsyBlocks.ARIA_MUSHROOM.get())).m_5456_(), (ResourceLocation)aria_rl);
        }
    }

    public static ResourceLocation rLoc(String resource) {
        return new ResourceLocation(MODID, resource);
    }
}

