/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.blemish;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.blemish.BlemishAnimations;
import uwu.juni.wetland_whimsy.content.entities.BlemishEntity;

@ParametersAreNonnullByDefault
public class BlemishModel<T extends BlemishEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("blemish"), "main");
    private final ModelPart model_base;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart tail;

    public BlemishModel(ModelPart root) {
        this.model_base = root.m_171324_("model_base");
        this.left_arm = this.model_base.m_171324_("left_arm");
        this.right_arm = this.model_base.m_171324_("right_arm");
        this.body = this.model_base.m_171324_("body");
        this.head = this.model_base.m_171324_("head");
        this.tail = this.model_base.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition model_base = partdefinition.m_171599_("model_base", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_arm = model_base.m_171599_("left_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(32, 23).m_171488_(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)8.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_arm = model_base.m_171599_("right_arm", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(32, 23).m_171488_(-1.0f, -8.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-6.0f, (float)8.0f, (float)-1.0f, (float)-0.0873f, (float)0.0f, (float)0.1745f));
        PartDefinition body = model_base.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition rib_large_left_r1 = body.m_171599_("rib_large_left_r1", CubeListBuilder.m_171558_().m_171514_(34, 12).m_171488_(-3.0f, -2.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(34, 12).m_171480_().m_171488_(-11.0f, -2.0f, -1.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)5.0f, (float)-5.0f, (float)2.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition rib_small_left_r1 = body.m_171599_("rib_small_left_r1", CubeListBuilder.m_171558_().m_171514_(35, 8).m_171488_(-2.0f, -1.75f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(35, 8).m_171480_().m_171488_(-9.0f, -1.75f, -1.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)4.0f, (float)-3.0f, (float)5.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition body_r1 = body.m_171599_("body_r1", CubeListBuilder.m_171558_().m_171514_(2, 0).m_171488_(-1.0f, -2.0f, -1.0f, 2.0f, 2.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)1.0f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition head = model_base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-4.0f, -8.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition tail = model_base.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(12, 2).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)13.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@Nonnull BlemishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_267799_(BlemishAnimations.BLEMISH_WALK, limbSwing, limbSwingAmount, 3.5f, 2.5f);
        this.m_233385_(entity.idleAnimationState, BlemishAnimations.BLEMISH_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.m_14036_((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104205_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model_base.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.model_base;
    }
}

