/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.client.entities.swampspider;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.client.entities.swampspider.SwampSpiderAnimations;
import uwu.juni.wetland_whimsy.content.entities.SwampSpiderEntity;

public class SwampSpiderModel<T extends SwampSpiderEntity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(WetlandWhimsy.rLoc("swamp_spider"), "main");
    private final ModelPart model_base;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart mushrooms;
    private final ModelPart left_legs;
    private final ModelPart front;
    private final ModelPart center;
    private final ModelPart back;
    private final ModelPart right_legs;
    private final ModelPart front2;
    private final ModelPart center2;
    private final ModelPart back2;

    public SwampSpiderModel(ModelPart root) {
        this.model_base = root.m_171324_("model_base");
        this.head = this.model_base.m_171324_("head");
        this.tail = this.model_base.m_171324_("tail");
        this.mushrooms = this.tail.m_171324_("mushrooms");
        this.left_legs = this.model_base.m_171324_("left_legs");
        this.front = this.left_legs.m_171324_("front");
        this.center = this.left_legs.m_171324_("center");
        this.back = this.left_legs.m_171324_("back");
        this.right_legs = this.model_base.m_171324_("right_legs");
        this.front2 = this.right_legs.m_171324_("front2");
        this.center2 = this.right_legs.m_171324_("center2");
        this.back2 = this.right_legs.m_171324_("back2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition model_base = partdefinition.m_171599_("model_base", CubeListBuilder.m_171558_().m_171514_(56, 32).m_171488_(-3.0f, -5.0f, -9.0f, 6.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)5.0f));
        PartDefinition head = model_base.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 64).m_171488_(-4.0f, -7.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.3f)).m_171514_(56, 50).m_171488_(-4.0f, -7.0f, -9.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-8.0f));
        PartDefinition tail = model_base.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -14.0f, 0.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition mushrooms = tail.m_171599_("mushrooms", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-14.0f, -14.0f, 3.0f, 28.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(0, 48).m_171488_(-14.0f, -14.0f, 13.0f, 28.0f, 16.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition shroom_cross_2_r1 = mushrooms.m_171599_("shroom_cross_2_r1", CubeListBuilder.m_171558_().m_171514_(32, 64).m_171488_(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-14.0f, (float)11.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition shroom_cross_1_r1 = mushrooms.m_171599_("shroom_cross_1_r1", CubeListBuilder.m_171558_().m_171514_(32, 64).m_171488_(-5.0f, -10.0f, 0.0f, 10.0f, 10.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-14.0f, (float)11.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition left_legs = model_base.m_171599_("left_legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front = left_legs.m_171599_("front", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front_r1 = front.m_171599_("front_r1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-7.0f, (float)0.0f, (float)0.2618f, (float)0.48f));
        PartDefinition center = left_legs.m_171599_("center", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition center_r1 = center.m_171599_("center_r1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition back = left_legs.m_171599_("back", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition back_r1 = back.m_171599_("back_r1", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.48f));
        PartDefinition right_legs = model_base.m_171599_("right_legs", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-5.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition front2 = right_legs.m_171599_("front2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition front_r2 = front2.m_171599_("front_r2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-7.0f, (float)0.0f, (float)0.2618f, (float)0.48f));
        PartDefinition center2 = right_legs.m_171599_("center2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition center_r2 = center2.m_171599_("center_r2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.48f));
        PartDefinition back2 = right_legs.m_171599_("back2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)5.0f));
        PartDefinition back_r2 = back2.m_171599_("back_r2", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(0.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-1.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.48f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@Nonnull SwampSpiderEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.m_267799_(SwampSpiderAnimations.SWAMP_SPIDER_WALK, limbSwing, limbSwingAmount, 1.5f, 2.5f);
        this.m_233385_(entity.idleAnimationState, SwampSpiderAnimations.SWAMP_SPIDER_IDLE, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float headYaw, float headPitch) {
        headYaw = Mth.m_14036_((float)headYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(@Nonnull PoseStack poseStack, @Nonnull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model_base.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.model_base;
    }

    public void prepareMobModel(@Nonnull SwampSpiderEntity entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.mushrooms.f_104207_ = !entity.isSheared();
    }
}

