/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AriaMushroomBlock
extends BushBlock
implements BonemealableBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61372_;
    protected static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);

    public AriaMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.UP));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        BlockState x = super.m_5573_(context);
        if (x == null) {
            return null;
        }
        Direction dir = context.m_43719_().m_122424_();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (d != dir) continue;
            return (BlockState)x.m_61124_(FACING, (Comparable)d);
        }
        return (BlockState)x.m_61124_(FACING, (Comparable)context.m_8125_());
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.m_61143_(FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    public boolean m_7370_(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nonnull BlockState state, boolean a) {
        return true;
    }

    public boolean m_214167_(@Nonnull Level level, @Nonnull RandomSource random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void m_214148_(@Nonnull ServerLevel level, @Nonnull RandomSource random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        this.tryGrow((Level)level, pos, state, 18);
    }

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (random.m_188503_(25) == 0) {
            this.tryGrow((Level)level, pos, state, 4);
        }
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        BlockPos new_pos = pos.m_121945_((Direction)state.m_61143_(FACING));
        return level.m_8055_(new_pos).m_60804_((BlockGetter)level, new_pos);
    }

    private void tryGrow(Level level, BlockPos pos, BlockState state, int chance) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = chance;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-3, -3, -3), (BlockPos)pos.m_7918_(3, 3, 3))) {
            if (!level.m_8055_(blockpos).m_60713_((Block)this) || --i > 0) continue;
            return;
        }
        Function<BlockPos, BlockPos> blockPosFn = oldPos -> oldPos.m_7918_(random.nextInt(3) - random.nextInt(3), random.nextInt(3) - random.nextInt(3), random.nextInt(3) - random.nextInt(3));
        BlockPos blockpos1 = blockPosFn.apply(pos);
        for (int k = 0; k < chance; ++k) {
            if (level.m_46859_(blockpos1) && this.canSurvive(level, blockpos1, state)) {
                pos = blockpos1;
            }
            blockpos1 = blockPosFn.apply(pos);
        }
        if (level.m_46859_(blockpos1) && this.canSurvive(level, blockpos1, state)) {
            level.m_7731_(blockpos1, this.getValidDir(level, blockpos1, state), 2);
        }
    }

    private boolean canSurvive(Level level, BlockPos pos, BlockState state) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (!(state = (BlockState)state.m_61124_(FACING, (Comparable)d)).m_60710_((LevelReader)level, pos)) continue;
            return true;
        }
        return false;
    }

    private BlockState getValidDir(Level level, BlockPos pos, BlockState state) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if (!(state = (BlockState)state.m_61124_(FACING, (Comparable)d)).m_60710_((LevelReader)level, pos)) continue;
            return state;
        }
        return state;
    }
}

