/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyParticleTypes;
import uwu.juni.wetland_whimsy.data.registries.WetlandWhimsyConfiguredFeatures;

@ParametersAreNonnullByDefault
public class BloodcapMushroomBlock
extends BushBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public BloodcapMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState a, BlockGetter b, BlockPos c, CollisionContext d) {
        return SHAPE;
    }

    public boolean m_7370_(LevelReader a, BlockPos b, BlockState c, boolean d) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growMushroom(level, pos, state, random);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(25) == 0) {
            this.tryGrow((Level)level, pos, state, random, 4);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6095_() == EntityType.f_20504_) {
            return;
        }
        if (level.f_46443_ || level.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity lEntity = (LivingEntity)entity;
            lEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 50));
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        VoxelShape voxelshape = this.m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_());
        Vec3 vec3 = voxelshape.m_83215_().m_82399_();
        double d0 = (double)pos.m_123341_() + vec3.f_82479_;
        double d1 = (double)pos.m_123343_() + vec3.f_82481_;
        for (int i = 0; i < 3; ++i) {
            if (random.m_216339_(0, 4) != 0) continue;
            level.m_7106_((ParticleOptions)WetlandWhimsyParticleTypes.BLOODCAP_SPORES.get(), d0 + random.m_188500_() / 5.0, (double)pos.m_123342_() + (0.65 - random.m_188500_()), d1 + random.m_188500_() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos new_pos = pos.m_7495_();
        BlockState new_state = level.m_8055_(new_pos);
        return new_state.m_204336_(BlockTags.f_144277_) && new_state.m_60804_((BlockGetter)level, new_pos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60804_(level, pos);
    }

    private void tryGrow(Level level, BlockPos pos, BlockState state, RandomSource random, int chance) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, -1, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!level.m_8055_(blockpos).m_60713_((Block)this) || --chance > 0) continue;
            return;
        }
        BlockPos blockpos1 = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(2) - random.m_188503_(2), random.m_188503_(3) - 1);
        for (int i = 0; i < chance; ++i) {
            if (level.m_46859_(blockpos1) && state.m_60710_((LevelReader)level, blockpos1)) {
                pos = blockpos1;
            }
            blockpos1 = pos.m_7918_(random.m_188503_(3) - 1, random.m_188503_(2) - random.m_188503_(2), random.m_188503_(3) - 1);
        }
        if (level.m_46859_(blockpos1) && state.m_60710_((LevelReader)level, blockpos1)) {
            level.m_7731_(blockpos1, state, 2);
        }
    }

    boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        Optional optional = level.m_9598_().m_175515_(Registries.f_256911_).m_203636_(WetlandWhimsyConfiguredFeatures.HUGE_BLOODCAP_MUSHROOM);
        level.m_7471_(pos, false);
        if (((ConfiguredFeature)((Holder)optional.get()).m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos)) {
            return true;
        }
        level.m_7731_(pos, state, 3);
        return false;
    }
}

