/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.blocks.entities;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.content.blocks.AncientBrazierBlock;
import uwu.juni.wetland_whimsy.data.sub_providers.WetlandWhimsyStructureLootDatagen;
import uwu.juni.wetland_whimsy.mixins.BaseSpawnerAccessor;

public class AncientBrazier
extends BaseSpawner {
    private int spawnedEntityCount = 0;
    private SimpleWeightedRandomList<ResourceLocation> lootTablesToEject = new SimpleWeightedRandomList.Builder().m_146271_((Object)WetlandWhimsyStructureLootDatagen.INTERMEDIATE_LOOT, 1).m_146271_((Object)WetlandWhimsyStructureLootDatagen.ANCIENT_COIN, 1).m_146270_();

    public void m_142523_(@Nonnull Level level, @Nonnull BlockPos pos, int id) {
        level.m_7696_(pos, (Block)WetlandWhimsyBlocks.ANCIENT_BRAZIER.get(), id, 0);
    }

    public void m_142667_(Level level, BlockPos pos, SpawnData data) {
        super.m_142667_(level, pos, data);
        if (level != null) {
            BlockState blockstate = level.m_8055_(pos);
            level.m_7260_(pos, blockstate, blockstate, 4);
        }
    }

    public void m_151311_(@Nonnull ServerLevel serverLevel, @Nonnull BlockPos pos) {
        Optional uuid;
        if (!((AncientBrazierBlock.Flame)((Object)serverLevel.m_8055_(pos).m_61143_(AncientBrazierBlock.FLAME))).equals((Object)AncientBrazierBlock.Flame.LIT)) {
            return;
        }
        int spawnDelay = ((BaseSpawnerAccessor)((Object)this)).getSpawnDelay();
        if (spawnDelay > 3) {
            ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(spawnDelay - 3);
        } else if (spawnDelay > 0) {
            ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(spawnDelay - 1);
        }
        if (spawnDelay == 1) {
            ++this.spawnedEntityCount;
            BlockEntity entity = serverLevel.m_7702_(pos);
            if (entity != null) {
                entity.m_6596_();
            }
            this.setRandomEntity(serverLevel, pos);
        }
        Optional<Object> optional = uuid = spawnDelay <= 0 ? this.spawnMob(serverLevel, pos) : Optional.empty();
        if (uuid.isPresent()) {
            ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(serverLevel.m_213780_().m_216339_(200, 400));
            for (int i = 0; i < serverLevel.m_213780_().m_216339_(0, 4); ++i) {
                this.spawnMob(serverLevel, pos);
            }
        }
        if (this.spawnedEntityCount >= 8) {
            this.spawnedEntityCount = 0;
            serverLevel.m_7731_(pos, (BlockState)serverLevel.m_8055_(pos).m_61124_(AncientBrazierBlock.FLAME, (Comparable)((Object)AncientBrazierBlock.Flame.SMOLDERING)), 2);
            this.ejectLoot(serverLevel, pos, serverLevel.m_213780_());
            return;
        }
    }

    private void setRandomEntity(ServerLevel level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        String entity = WetlandWhimsy.config.ancientBrazierEntities.get(random.m_216339_(0, WetlandWhimsy.config.ancientBrazierEntities.size()));
        this.m_253197_((EntityType)BuiltInRegistries.f_256780_.m_7745_(ResourceLocation.m_135820_((String)entity)), (Level)level, random, pos);
    }

    public Optional<UUID> spawnMob(ServerLevel level, BlockPos pos) {
        double d2;
        RandomSource randomsource = level.m_213780_();
        SpawnData spawndata = ((BaseSpawnerAccessor)((Object)this)).invokeGetOrCreateNextSpawnData((Level)level, level.m_213780_(), pos);
        CompoundTag compoundtag = spawndata.f_186561_();
        ListTag listtag = compoundtag.m_128437_("Pos", 6);
        Optional optional = EntityType.m_20637_((CompoundTag)compoundtag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        WetlandWhimsy.LOGGER.info("EntityType exists");
        int i = listtag.size();
        double d0 = i >= 1 ? listtag.m_128772_(0) : (double)pos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 7.0 + 0.5;
        double d1 = i >= 2 ? listtag.m_128772_(1) : (double)(pos.m_123342_() + randomsource.m_188503_(3) - 1);
        double d = d2 = i >= 3 ? listtag.m_128772_(2) : (double)pos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * 7.0 + 0.5;
        if (!level.m_45772_(((EntityType)optional.get()).m_20585_(d0, d1, d2))) {
            return Optional.empty();
        }
        WetlandWhimsy.LOGGER.info("Collision exists");
        Vec3 vec3 = new Vec3(d0, d1, d2);
        if (!AncientBrazier.inLineOfSight((Level)level, pos.m_252807_(), vec3)) {
            return Optional.empty();
        }
        WetlandWhimsy.LOGGER.info("In line of sight");
        BlockPos blockpos = BlockPos.m_274446_((Position)vec3);
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)level, p_312375_ -> {
            p_312375_.m_7678_(d0, d1, d2, randomsource.m_188501_() * 360.0f, 0.0f);
            return p_312375_;
        });
        if (entity == null) {
            return Optional.empty();
        }
        WetlandWhimsy.LOGGER.info("Entity loaded");
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.m_6914_((LevelReader)level)) {
                return Optional.empty();
            }
            MobSpawnEvent.FinalizeSpawn event = ForgeEventFactory.onFinalizeSpawnSpawner((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(entity.m_20183_()), null, (CompoundTag)compoundtag, (BaseSpawner)this);
            if (event != null && spawndata.m_186567_().m_128440_() == 1 && spawndata.m_186567_().m_128425_("id", 8)) {
                ((Mob)entity).m_6518_((ServerLevelAccessor)level, event.getDifficulty(), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
            }
            mob.m_21530_();
        }
        if (!level.m_8860_(entity)) {
            return Optional.empty();
        }
        level.m_46796_(2004, pos, 0);
        level.m_142346_(entity, GameEvent.f_157810_, blockpos);
        if (entity instanceof Mob) {
            ((Mob)entity).m_21373_();
        }
        return Optional.of(entity.m_20148_());
    }

    private static boolean inLineOfSight(Level level, Vec3 spawnerPos, Vec3 mobPos) {
        BlockHitResult blockhitresult = level.m_45547_(new ClipContext(mobPos, spawnerPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        return blockhitresult.m_82425_().equals((Object)BlockPos.m_274446_((Position)spawnerPos)) || blockhitresult.m_6662_() == HitResult.Type.MISS;
    }

    private void ejectLoot(ServerLevel level, BlockPos pos, RandomSource random) {
        Optional x = this.lootTablesToEject.m_216829_(random);
        if (x.isEmpty()) {
            return;
        }
        LootParams params = new LootParams.Builder(level).m_287235_(LootContextParamSets.f_81410_);
        LootTable table = level.m_7654_().m_278653_().m_278676_((ResourceLocation)((WeightedEntry.Wrapper)x.get()).m_146310_());
        ObjectArrayList loot = table.m_287195_(params);
        if (loot.isEmpty()) {
            return;
        }
        for (ItemStack itemstack : loot) {
            DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)itemstack, (int)2, (Direction)Direction.UP, (Position)Vec3.m_82539_((Vec3i)pos).m_231075_(Direction.UP, 1.2));
        }
        level.m_5594_(null, pos, SoundEvents.f_144242_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public CompoundTag m_186381_(@Nonnull CompoundTag tag) {
        tag.m_128376_("SpawnedEntityCount", (short)this.spawnedEntityCount);
        return super.m_186381_(tag);
    }

    public void m_151328_(@Nullable Level level, @Nonnull BlockPos pos, @Nonnull CompoundTag tag) {
        this.spawnedEntityCount = tag.m_128451_("SpawnedEntityCount");
        super.m_151328_(level, pos, tag);
    }
}

