/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities;

import com.google.common.collect.ImmutableList;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.content.WetlandWhimsySounds;
import uwu.juni.wetland_whimsy.content.entities.goals.CraneFlyGoal;
import uwu.juni.wetland_whimsy.tags.WetlandWhimsyTags;

@ParametersAreNonnullByDefault
public class CraneEntity
extends Animal {
    public boolean befriended = false;
    static final String befriendedId = "befriended";
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState flyAnimationState = new AnimationState();

    public CraneEntity(EntityType<? extends CraneEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        ImmutableList goals = ImmutableList.of((Object)new FloatGoal((Mob)this), (Object)new LeapAtTargetGoal((Mob)this, 0.4f), (Object)new MeleeAttackGoal((PathfinderMob)this, 1.0, true), (Object)new PanicGoal((PathfinderMob)this, 1.2), (Object)new BreedGoal((Animal)this, 1.0), (Object)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(WetlandWhimsyTags.Items.CRANE_FOOD), false), (Object)new FollowParentGoal((Animal)this, 1.1), (Object)new RandomStrollGoal((PathfinderMob)this, 1.0), (Object)((Object)new CraneFlyGoal(this)), (Object)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), (Object)new RandomLookAroundGoal((Mob)this));
        int priority = 0;
        for (Goal goal : goals) {
            this.f_21345_.m_25352_(priority, goal);
            ++priority;
        }
        this.f_21346_.m_25352_(priority, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true, e -> this.befriended));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22279_, 0.285).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 6.0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(befriendedId, this.befriended);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_(befriendedId)) {
            this.befriended = compound.m_128471_(befriendedId);
        }
    }

    void setupAnimationStates() {
        if (!this.m_20096_() && !this.m_20069_()) {
            this.idleAnimationState.m_216973_();
            this.flyAnimationState.m_216982_(this.f_19797_);
        } else {
            this.flyAnimationState.m_216973_();
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0 && !this.m_21023_(MobEffects.f_19591_)) {
            this.m_20256_(vec3.m_82542_(1.0, 0.8, 1.0));
        }
    }

    public boolean m_6898_(ItemStack item) {
        return item.m_204117_(WetlandWhimsyTags.Items.CRANE_FOOD);
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob otherParent) {
        return (AgeableMob)((EntityType)WetlandWhimsyEntityTypes.CRANE.get()).m_20615_((Level)level);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        BiFunction<Player, InteractionHand, InteractionResult> fn = (x$0, x$1) -> super.m_6071_(x$0, x$1);
        if (!this.m_6898_(player.m_21120_(hand))) {
            fn = (x$0, x$1) -> super.m_6071_(x$0, x$1);
        } else if (!this.befriended && !this.m_6162_()) {
            fn = this::befriend;
        } else if (this.m_21223_() < this.m_21233_()) {
            fn = this::heal;
        }
        return fn.apply(player, hand);
    }

    InteractionResult heal(Player player, InteractionHand hand) {
        FoodProperties props = player.m_21120_(hand).getFoodProperties((LivingEntity)this);
        this.m_5634_(props == null ? 4.0f : (float)(props.m_38744_() * 2));
        this.feed(player, hand);
        return InteractionResult.SUCCESS;
    }

    InteractionResult befriend(Player player, InteractionHand hand) {
        this.befriended = true;
        this.feed(player, hand);
        this.sendParticles(ParticleTypes.f_123748_, 10);
        return InteractionResult.SUCCESS;
    }

    void feed(Player player, InteractionHand hand) {
        this.m_142075_(player, hand, player.m_21120_(hand));
        this.m_146850_(GameEvent.f_157806_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            if (this.befriended) {
                this.sendParticles(ParticleTypes.f_123792_, 3);
            }
            this.befriended = false;
        }
        return super.m_6469_(source, amount);
    }

    <T extends ParticleOptions> void sendParticles(T type, int amount) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        Vec3 pos = this.m_20182_();
        sLevel.m_8767_(type, pos.f_82479_, pos.f_82480_, pos.f_82481_, amount, 0.5, 1.0, 0.0, 0.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)WetlandWhimsySounds.CRANE_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)WetlandWhimsySounds.CRANE_HIT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)WetlandWhimsySounds.CRANE_DEATH.get();
    }
}

