/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.content.entities;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.Tags;
import uwu.juni.wetland_whimsy.data.sub_providers.WetlandWhimsyMiscLoot;

public class SwampSpiderEntity
extends Spider {
    private static final EntityDataAccessor<Boolean> DATA_SHEARED = SynchedEntityData.m_135353_(SwampSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    static final String SHEARED_ID = "sheared";
    public final AnimationState idleAnimationState = new AnimationState();

    public SwampSpiderEntity(EntityType<? extends SwampSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SHEARED, (Object)false);
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_(SHEARED_ID, this.isSheared());
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.setSheared(compound.m_128471_(SHEARED_ID));
    }

    public static AttributeSupplier.Builder m_33815_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.375).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22276_, 20.0);
    }

    void setupAnimationStates() {
        this.idleAnimationState.m_216982_(this.f_19797_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
    }

    public boolean m_7327_(@Nonnull Entity entity) {
        if (!super.m_7327_(entity)) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            int i;
            LivingEntity lEntity = (LivingEntity)entity;
            switch (this.m_9236_().m_46791_()) {
                case NORMAL: {
                    int n = 3;
                    break;
                }
                case HARD: {
                    int n = 5;
                    break;
                }
                default: {
                    int n = i = 0;
                }
            }
            if (i > 0) {
                lEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, i * 20, 0), (Entity)this);
            }
        }
        return true;
    }

    public double m_6048_() {
        return super.m_6048_() * 0.5;
    }

    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isSheared() || !this.m_6084_() || !itemstack.m_204117_(Tags.Items.SHEARS)) {
            return super.m_6071_(player, hand);
        }
        this.m_9236_().m_247517_(player, player.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS);
        this.setSheared(true);
        this.spawnShearedMushrooms();
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!this.m_9236_().f_46443_) {
            itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(DATA_SHEARED, (Object)sheared);
    }

    void spawnShearedMushrooms() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sLevel = (ServerLevel)level;
        LootTable table = sLevel.m_7654_().m_278653_().m_278676_(WetlandWhimsyMiscLoot.SWAMP_SPIDER_SHEARING);
        LootParams params = new LootParams.Builder(sLevel).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81457_, (Object)this.m_269291_().m_269264_()).m_287235_(LootContextParamSets.f_81415_);
        for (ItemStack item : table.m_287195_(params)) {
            this.m_5552_(item, this.m_20206_());
        }
    }

    protected ResourceLocation m_7582_() {
        return this.isSheared() ? WetlandWhimsyMiscLoot.SWAMP_SPIDER_SHEARED : super.m_7582_();
    }
}

