/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.data.registries;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyEntityTypes;
import uwu.juni.wetland_whimsy.data.registries.WetlandWhimsyPlacedFeatures;

public class WetlandWhimsyBiomes {
    public static final ResourceKey<Biome> MARSH = WetlandWhimsyBiomes.createKey("marsh");
    static final BiomeSpecialEffects MARSH_EFFECTS = new BiomeSpecialEffects.Builder().m_48019_(11453661).m_48040_(8560340).m_48034_(4484228).m_48037_(4484228).m_48045_(8820557).m_48043_(5665336).m_48021_(new Music((Holder)SoundEvents.f_215730_, 12000, 24000, false)).m_48018_();

    public static void bootstap(BootstapContext<Biome> context) {
        context.m_255272_(MARSH, (Object)new Biome.BiomeBuilder().m_264558_(true).m_47609_(0.8f).m_47611_(0.9f).m_47603_(MARSH_EFFECTS).m_47599_(Biome.TemperatureModifier.NONE).m_47605_(WetlandWhimsyBiomes.marshMobSettings()).m_47601_(WetlandWhimsyBiomes.marshGenSettings(context)).m_47592_());
    }

    static MobSpawnSettings marshMobSettings() {
        MobSpawnSettings.Builder mobs = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobs);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)mobs);
        BiomeDefaultFeatures.m_126740_((MobSpawnSettings.Builder)mobs, (int)10, (int)8, (int)20);
        mobs.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_217012_, 10, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)WetlandWhimsyEntityTypes.CRANE.get(), 30, 2, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 100, 4, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20562_, 30, 3, 3));
        return mobs.m_48381_();
    }

    static BiomeGenerationSettings marshGenSettings(BootstapContext<Biome> context) {
        HolderGetter placedFeatures = context.m_255420_(Registries.f_256988_);
        HolderGetter configuredCarvers = context.m_255420_(Registries.f_257003_);
        BiomeGenerationSettings.Builder settings = new BiomeGenerationSettings.Builder(placedFeatures, configuredCarvers);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)settings);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)settings);
        WetlandWhimsyBiomes.addFeatures(settings, GenerationStep.Decoration.UNDERGROUND_STRUCTURES, CavePlacements.f_195251_, CavePlacements.f_195237_, CavePlacements.f_195238_, CavePlacements.f_195235_, CavePlacements.f_195236_);
        WetlandWhimsyBiomes.addFeatures(settings, GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195325_, OrePlacements.f_195326_, OrePlacements.f_195327_, OrePlacements.f_195328_, OrePlacements.f_195329_, OrePlacements.f_195330_, OrePlacements.f_195331_, OrePlacements.f_195332_, OrePlacements.f_195333_, OrePlacements.f_195334_, OrePlacements.f_195335_, OrePlacements.f_195336_, OrePlacements.f_195338_, OrePlacements.f_195339_, OrePlacements.f_195340_, OrePlacements.f_195302_, OrePlacements.f_195303_, OrePlacements.f_195304_, OrePlacements.f_195305_, OrePlacements.f_195306_, OrePlacements.f_195307_, OrePlacements.f_195312_, CavePlacements.f_195242_, MiscOverworldPlacements.f_195268_);
        WetlandWhimsyBiomes.addFeatures(settings, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195417_, VegetationPlacements.f_195455_, VegetationPlacements.f_195461_, VegetationPlacements.f_195403_, VegetationPlacements.f_195450_, AquaticPlacements.f_195222_, WetlandWhimsyPlacedFeatures.LIMESTONE_BLOB_MARSH, WetlandWhimsyPlacedFeatures.MUD_POOL_MARSH, WetlandWhimsyPlacedFeatures.MUD_PATCH_MARSH, WetlandWhimsyPlacedFeatures.TREES_MARSH, WetlandWhimsyPlacedFeatures.SUPER_THICK_CORDGRASS_PATCH, WetlandWhimsyPlacedFeatures.MUD_BLOB);
        return settings.m_255380_();
    }

    @SafeVarargs
    static void addFeatures(BiomeGenerationSettings.Builder settings, GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> ... features) {
        for (ResourceKey<PlacedFeature> feature : features) {
            settings.m_255155_(decoration, feature);
        }
    }

    static ResourceKey<Biome> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }
}

