/*
 * Decompiled with CFR 0.152.
 */
package uwu.juni.wetland_whimsy.data.registries;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import uwu.juni.wetland_whimsy.WetlandWhimsy;
import uwu.juni.wetland_whimsy.content.WetlandWhimsyBlocks;
import uwu.juni.wetland_whimsy.data.registries.WetlandWhimsyConfiguredFeatures;

public class WetlandWhimsyPlacedFeatures {
    public static final ResourceKey<PlacedFeature> TREES_BOG = WetlandWhimsyPlacedFeatures.createKey("trees_bog");
    public static final ResourceKey<PlacedFeature> TREES_MARSH = WetlandWhimsyPlacedFeatures.createKey("trees_marsh");
    public static final ResourceKey<PlacedFeature> LIMESTONE_BLOB_SWAMP = WetlandWhimsyPlacedFeatures.createKey("limestone_blob_swamp");
    public static final ResourceKey<PlacedFeature> LIMESTONE_BLOB_MARSH = WetlandWhimsyPlacedFeatures.createKey("limestone_blob_marsh");
    public static final ResourceKey<PlacedFeature> MUD_PATCH_SWAMP = WetlandWhimsyPlacedFeatures.createKey("mud_patch_swamp");
    public static final ResourceKey<PlacedFeature> MUD_PATCH_MARSH = WetlandWhimsyPlacedFeatures.createKey("mud_patch_marsh");
    public static final ResourceKey<PlacedFeature> MUD_POOL_SWAMP = WetlandWhimsyPlacedFeatures.createKey("mud_pool_swamp");
    public static final ResourceKey<PlacedFeature> MUD_POOL_MARSH = WetlandWhimsyPlacedFeatures.createKey("mud_pool_marsh");
    public static final ResourceKey<PlacedFeature> CORDGRASS_PATCH = WetlandWhimsyPlacedFeatures.createKey("cordgrass_patch");
    public static final ResourceKey<PlacedFeature> PENNYWORT_PATCH = WetlandWhimsyPlacedFeatures.createKey("pennywort_patch");
    public static final ResourceKey<PlacedFeature> BLOODCAP_PATCH = WetlandWhimsyPlacedFeatures.createKey("bloodcap_patch");
    public static final ResourceKey<PlacedFeature> BLOODCAP_PATCH_SURFACE = WetlandWhimsyPlacedFeatures.createKey("bloodcap_patch_surface");
    public static final ResourceKey<PlacedFeature> HUGE_ARIA = WetlandWhimsyPlacedFeatures.createKey("huge_aria");
    public static final ResourceKey<PlacedFeature> MUD_BLOB = WetlandWhimsyPlacedFeatures.createKey("mud_blob");
    public static final ResourceKey<PlacedFeature> SUPER_THICK_CORDGRASS_PATCH = WetlandWhimsyPlacedFeatures.createKey("super_thick_cordgrass_patch");
    public static final ResourceKey<PlacedFeature> FERN_CLONE_CAUSE_FUCK_THE_FEATURE_CYCLE = WetlandWhimsyPlacedFeatures.createKey("fern_clone");

    public static void bootstap(BootstapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.m_255420_(Registries.f_256911_);
        context.m_255272_(TREES_BOG, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.TREES_BOG), WetlandWhimsyPlacedFeatures.bogTreePlacement()));
        context.m_255272_(TREES_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.TREES_MARSH), WetlandWhimsyPlacedFeatures.marshTreePlacement()));
        context.m_255272_(CORDGRASS_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.CORDGRASS_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(PENNYWORT_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.PENNYWORT_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(BLOODCAP_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.BLOODCAP_PATCH), List.of(CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)20, (int)50)), PlacementUtils.f_195360_, InSquarePlacement.m_191715_(), SurfaceRelativeThresholdFilter.m_191930_((Heightmap.Types)Heightmap.Types.OCEAN_FLOOR_WG, (int)Integer.MIN_VALUE, (int)-64), BiomeFilter.m_191561_())));
        context.m_255272_(BLOODCAP_PATCH_SURFACE, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.BLOODCAP_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(HUGE_ARIA, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.HUGE_ARIA_MUSHROOM), List.of(RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, BiomeFilter.m_191561_(), PlacementUtils.m_206493_((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get())))));
        context.m_255272_(LIMESTONE_BLOB_SWAMP, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.LIMESTONE_BLOB), List.of(InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76193_})), BiomeFilter.m_191561_())));
        context.m_255272_(LIMESTONE_BLOB_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.LIMESTONE_BLOB), List.of(InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224782_((Fluid[])new Fluid[]{Fluids.f_76193_})), BiomeFilter.m_191561_())));
        context.m_255272_(MUD_BLOB, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.MUD_BLOB), List.of(PlacementUtils.m_195364_((int)2, (float)0.5f, (int)1), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)2), PlacementUtils.f_195355_, BiomeFilter.m_191561_())));
        context.m_255272_(MUD_PATCH_SWAMP, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.MUD_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(MUD_PATCH_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.MUD_PATCH), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(MUD_POOL_SWAMP, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.MUD_POOL), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(MUD_POOL_MARSH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.MUD_POOL), WetlandWhimsyPlacedFeatures.foliagePlacement()));
        context.m_255272_(SUPER_THICK_CORDGRASS_PATCH, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(WetlandWhimsyConfiguredFeatures.CORDGRASS_PATCH), WetlandWhimsyPlacedFeatures.marshFoliagePlacement()));
        context.m_255272_(FERN_CLONE_CAUSE_FUCK_THE_FEATURE_CYCLE, (Object)new PlacedFeature((Holder)configuredFeatures.m_255043_(VegetationFeatures.f_195189_), List.of(RarityFilter.m_191900_((int)4), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_())));
    }

    public static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)WetlandWhimsy.rLoc(name));
    }

    public static List<PlacementModifier> bogTreePlacement() {
        return ImmutableList.builder().add((Object)PlacementUtils.m_195364_((int)2, (float)0.5f, (int)3)).add((Object)InSquarePlacement.m_191715_()).add((Object)SurfaceWaterDepthFilter.m_191950_((int)2)).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).add((Object)PlacementUtils.m_206493_((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))).build();
    }

    public static List<PlacementModifier> marshTreePlacement() {
        return ImmutableList.builder().add((Object)CountPlacement.m_191628_((int)2)).add((Object)RarityFilter.m_191900_((int)7)).add((Object)InSquarePlacement.m_191715_()).add((Object)SurfaceWaterDepthFilter.m_191950_((int)0)).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).add((Object)PlacementUtils.m_206493_((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))).build();
    }

    public static List<PlacementModifier> foliagePlacement() {
        return ImmutableList.builder().add((Object)PlacementUtils.f_195354_).add((Object)CountPlacement.m_191628_((int)3)).add((Object)RarityFilter.m_191900_((int)3)).add((Object)InSquarePlacement.m_191715_()).add((Object)PlacementUtils.m_206493_((Block)Blocks.f_50112_)).add((Object)BiomeFilter.m_191561_()).build();
    }

    public static List<PlacementModifier> marshFoliagePlacement() {
        return ImmutableList.builder().add((Object)PlacementUtils.m_195364_((int)17, (float)0.5f, (int)6)).add((Object)InSquarePlacement.m_191715_()).add((Object)SurfaceWaterDepthFilter.m_191950_((int)2)).add((Object)PlacementUtils.f_195355_).add((Object)BiomeFilter.m_191561_()).add((Object)PlacementUtils.m_206493_((Block)((Block)WetlandWhimsyBlocks.BALD_CYPRESS_SAPLING.get()))).build();
    }
}

