/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.input;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.GenericInputScreen;
import com.getitemfromblock.create_tweaked_controllers.gui.InputConfig.JoystickButtonScreen;
import com.getitemfromblock.create_tweaked_controllers.input.GenericInput;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickInputs;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class JoystickButtonInput
implements GenericInput {
    public int buttonID = -1;
    public boolean invertValue = false;

    public JoystickButtonInput(int buttonID) {
        this.buttonID = buttonID;
    }

    public JoystickButtonInput() {
    }

    @Override
    public boolean GetButtonValue() {
        if (!this.IsInputValid()) {
            return this.invertValue;
        }
        return this.invertValue ? !JoystickInputs.GetButton(this.buttonID) : JoystickInputs.GetButton(this.buttonID);
    }

    @Override
    public float GetAxisValue() {
        return this.GetButtonValue() ? 1.0f : 0.0f;
    }

    @Override
    public MutableComponent GetDisplayName() {
        return CreateTweakedControllers.translateDirect("gui_input_joystick_button", "" + this.buttonID);
    }

    @Override
    public boolean IsInputValid() {
        return this.buttonID < JoystickInputs.GetButtonCount() && this.buttonID >= 0;
    }

    @Override
    public void Serialize(DataOutputStream buf) throws IOException {
        buf.writeBoolean(this.invertValue);
        buf.writeInt(this.buttonID);
    }

    @Override
    public void Deserialize(DataInputStream buf) throws IOException {
        this.invertValue = buf.readBoolean();
        this.buttonID = buf.readInt();
    }

    @Override
    public GenericInput.InputType GetType() {
        return GenericInput.InputType.JOYSTICK_BUTTON;
    }

    @Override
    public int GetValue() {
        return this.buttonID;
    }

    @Override
    public GenericInputScreen OpenConfigScreen(Screen previous, Component comp) {
        return new JoystickButtonScreen(previous, comp, this);
    }
}

