/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.item;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.config.ModClientConfig;
import com.getitemfromblock.create_tweaked_controllers.controller.TweakedLinkedControllerClientHandler;
import com.getitemfromblock.create_tweaked_controllers.input.GamepadInputs;
import com.getitemfromblock.create_tweaked_controllers.item.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TweakedLinkedControllerItemRenderer
extends CustomRenderedItemModelRenderer {
    protected static final PartialModel BASE;
    protected static final PartialModel[] CONTROLLERS;
    protected static final PartialModel BUTTON;
    protected static final PartialModel JOYSTICK;
    protected static final PartialModel TRIGGER;
    protected static final PartialModel[] BUTTONS_LEFT;
    protected static final PartialModel[] BUTTONS_UP;
    protected static final PartialModel[] BUTTONS_DOWN;
    protected static final PartialModel[] BUTTONS_RIGHT;
    static LerpedFloat equipProgress;
    static ArrayList<LerpedFloat> buttons;
    static ArrayList<LerpedFloat> axis;
    private static final Vec3[] positionList;

    public static void earlyTick() {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        boolean active = TweakedLinkedControllerClientHandler.MODE != TweakedLinkedControllerClientHandler.Mode.IDLE;
        equipProgress.chase(active ? 1.0 : 0.0, (double)0.2f, LerpedFloat.Chaser.EXP);
        equipProgress.tickChaser();
    }

    public static void tick() {
        LerpedFloat lerpedFloat;
        int i;
        if (Minecraft.m_91087_().m_91104_() || TweakedLinkedControllerClientHandler.MODE == TweakedLinkedControllerClientHandler.Mode.IDLE) {
            return;
        }
        for (i = 0; i < buttons.size(); ++i) {
            lerpedFloat = buttons.get(i);
            lerpedFloat.chase(GamepadInputs.buttons[i] ? 1.0 : 0.0, (double)0.4f, LerpedFloat.Chaser.EXP);
            lerpedFloat.tickChaser();
        }
        for (i = 0; i < axis.size(); ++i) {
            lerpedFloat = axis.get(i);
            lerpedFloat.chase((double)GamepadInputs.axis[i], 1.0, LerpedFloat.Chaser.LINEAR);
            lerpedFloat.tickChaser();
        }
    }

    public static void resetButtons() {
        int i;
        for (i = 0; i < buttons.size(); ++i) {
            buttons.get(i).startWithValue(0.0);
        }
        for (i = 0; i < axis.size(); ++i) {
            axis.get(i).startWithValue(i < 4 ? 0.0 : -1.0);
        }
    }

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        TweakedLinkedControllerItemRenderer.renderNormal(stack, model, renderer, transformType, ms, light);
    }

    protected static void renderNormal(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, int light) {
        TweakedLinkedControllerItemRenderer.render(stack, model, renderer, transformType, ms, light, RenderType.NORMAL, false, false);
    }

    public static void renderInLectern(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, int light, boolean active, boolean renderDepression) {
        TweakedLinkedControllerItemRenderer.render(stack, model, renderer, transformType, ms, light, RenderType.LECTERN, active, renderDepression);
    }

    protected static void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, int light, RenderType renderType, boolean active, boolean renderDepression) {
        float pt = AnimationTickHolder.getPartialTicks();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        ms.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        if (renderType == RenderType.NORMAL && mc.f_91074_ != null) {
            boolean noControllerInMain;
            boolean rightHanded = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
            ItemDisplayContext mainHand = rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            ItemDisplayContext offHand = rightHanded ? ItemDisplayContext.FIRST_PERSON_LEFT_HAND : ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            active = false;
            boolean bl = noControllerInMain = !ModItems.TWEAKED_LINKED_CONTROLLER.isIn(mc.f_91074_.m_21205_());
            if (transformType == mainHand || transformType == offHand && noControllerInMain) {
                int handModifier;
                float equip = equipProgress.getValue(pt);
                int n = handModifier = transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -1 : 1;
                if (transformType == mainHand && mc.f_91074_.m_21206_().m_41619_() || transformType == offHand && mc.f_91074_.m_21205_().m_41619_()) {
                    float modelDisplacementValue = 0.93106616f;
                    msr.translate(0.1f * equip, equip / 3.0f, equip * (float)handModifier * 0.93106616f);
                    msr.rotateZDegrees(equip * -10.0f);
                } else {
                    msr.translate(0.0f, equip / 4.0f, equip / 4.0f * (float)handModifier);
                    msr.rotateYDegrees(equip * -30.0f * (float)handModifier);
                    msr.rotateZDegrees(equip * -30.0f);
                }
                active = true;
            }
            if (transformType == ItemDisplayContext.GUI) {
                if (stack == mc.f_91074_.m_21205_()) {
                    active = true;
                }
                if (stack == mc.f_91074_.m_21206_() && noControllerInMain) {
                    active = true;
                }
            }
            active &= TweakedLinkedControllerClientHandler.MODE != TweakedLinkedControllerClientHandler.Mode.IDLE;
            renderDepression = true;
        }
        int c = ((ModClientConfig.ControllerLayoutType)((Object)ModClientConfig.CONTROLLER_LAYOUT_TYPE.get())).ordinal();
        if (!active) {
            renderer.render(CONTROLLERS[c].get(), light);
            ms.m_85849_();
            return;
        }
        renderer.render(BASE.get(), light);
        float s = 0.0625f;
        float b = s * -0.75f;
        int index = 0;
        if (renderType == RenderType.NORMAL && TweakedLinkedControllerClientHandler.MODE == TweakedLinkedControllerClientHandler.Mode.BIND) {
            int i = (int)Mth.m_14179_((float)((Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() / 4.0f)) + 1.0f) / 2.0f), (float)5.0f, (float)15.0f);
            light = i << 20;
        }
        ms.m_85836_();
        BakedModel button = BUTTONS_DOWN[c].get();
        TweakedLinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression, false);
        button = BUTTONS_RIGHT[c].get();
        TweakedLinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression, false);
        button = BUTTONS_LEFT[c].get();
        TweakedLinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression, false);
        button = BUTTONS_UP[c].get();
        TweakedLinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index++, renderDepression, false);
        button = TRIGGER.get();
        while (index < 6) {
            ms.m_85836_();
            msr.translate(positionList[index - 4]);
            TweakedLinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index, renderDepression, true);
            ms.m_85849_();
            ++index;
        }
        button = BUTTON.get();
        while (index < 15) {
            if (index != 9 && index != 10) {
                ms.m_85836_();
                msr.translate(positionList[index - 4]);
                TweakedLinkedControllerItemRenderer.renderButton(renderer, ms, light, pt, button, b, index, renderDepression, false);
                ms.m_85849_();
            }
            ++index;
        }
        button = JOYSTICK.get();
        TweakedLinkedControllerItemRenderer.renderJoystick(renderer, ms, light, pt, button, b, renderDepression, false);
        TweakedLinkedControllerItemRenderer.renderJoystick(renderer, ms, light, pt, button, b, renderDepression, true);
        button = TRIGGER.get();
        TweakedLinkedControllerItemRenderer.renderTrigger(renderer, ms, light, pt, button, false);
        TweakedLinkedControllerItemRenderer.renderTrigger(renderer, ms, light, pt, button, true);
        ms.m_85849_();
        ms.m_85849_();
    }

    protected static void renderButton(PartialItemModelRenderer renderer, PoseStack ms, int light, float pt, BakedModel button, float b, int index, boolean renderDepression, boolean isSideway) {
        ms.m_85836_();
        if (renderDepression) {
            float depression = b * buttons.get(index).getValue(pt);
            if (isSideway) {
                ms.m_252880_(-depression, 0.0f, 0.0f);
            } else {
                ms.m_252880_(0.0f, depression, 0.0f);
            }
        }
        renderer.renderSolid(button, light);
        ms.m_85849_();
    }

    protected static void renderTrigger(PartialItemModelRenderer renderer, PoseStack ms, int light, float pt, BakedModel trigger, boolean isRight) {
        ms.m_85836_();
        float delta = -0.046875f;
        Vec3 pos = positionList[isRight ? 12 : 11];
        float value = axis.get(isRight ? 5 : 4).getValue(pt);
        value = (value + 1.0f) / 2.0f * -0.046875f;
        ms.m_85837_(pos.f_82479_ - (double)value, pos.f_82480_, pos.f_82481_);
        renderer.renderSolid(trigger, light);
        ms.m_85849_();
    }

    protected static void renderJoystick(PartialItemModelRenderer renderer, PoseStack ms, int light, float pt, BakedModel joystick, float b, boolean renderDepression, boolean isRight) {
        float y;
        float x;
        ms.m_85836_();
        double delta = 0.46875;
        Vec3 pos = positionList[isRight ? 6 : 5].m_82492_(0.46875, 0.46875, 0.46875);
        ms.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        ms.m_85836_();
        if (isRight) {
            x = axis.get(2).getValue(pt);
            y = axis.get(3).getValue(pt);
        } else {
            x = axis.get(0).getValue(pt);
            y = axis.get(1).getValue(pt);
        }
        Vector3f ax = new Vector3f(-x, 0.0f, -y);
        double angle = x * x + y * y;
        angle = Math.min(Math.sqrt(angle), 1.0) * (double)0.6f;
        if (ax.dot((Vector3fc)ax) < 0.001f) {
            ax = new Vector3f(-1.0f, 0.0f, -1.0f);
            angle = 0.0;
        }
        ax.normalize();
        ms.m_252781_(new Quaternionf(new AxisAngle4f((float)angle, (Vector3fc)ax)));
        if (renderDepression) {
            float depression = b * buttons.get(isRight ? 10 : 9).getValue(pt);
            ms.m_252880_(0.0f, depression, 0.0f);
        }
        renderer.renderSolid(joystick, light);
        ms.m_85849_();
        ms.m_85849_();
    }

    static {
        int i;
        BASE = PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/powered"));
        CONTROLLERS = new PartialModel[]{PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/controller_x")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/controller_n")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/controller_p"))};
        BUTTON = PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button"));
        JOYSTICK = PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/joystick"));
        TRIGGER = PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/trigger"));
        BUTTONS_LEFT = new PartialModel[]{PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_x_x")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_n_y")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_p_s"))};
        BUTTONS_UP = new PartialModel[]{PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_x_y")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_n_x")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_p_t"))};
        BUTTONS_DOWN = new PartialModel[]{PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_x_a")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_n_b")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_p_x"))};
        BUTTONS_RIGHT = new PartialModel[]{PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_x_b")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_n_a")), PartialModel.of((ResourceLocation)CreateTweakedControllers.asResource("item/tweaked_linked_controller/button_p_c"))};
        equipProgress = LerpedFloat.linear().startWithValue(0.0);
        buttons = new ArrayList(15);
        for (i = 0; i < 15; ++i) {
            buttons.add(LerpedFloat.linear().startWithValue(0.0));
        }
        axis = new ArrayList(6);
        for (i = 0; i < 6; ++i) {
            axis.add(LerpedFloat.linear().startWithValue(i < 4 ? 0.0 : -1.0));
        }
        positionList = new Vec3[]{new Vec3(3.0, 0.9, 11.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(3.0, 0.9, 2.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(6.0, 1.0, 8.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(6.0, 1.0, 6.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(5.0, 1.0, 7.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(6.0, 0.5, 11.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(9.0, 0.5, 5.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(8.0, 1.0, 9.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(9.0, 1.0, 8.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(10.0, 1.0, 9.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(9.0, 1.0, 10.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(3.0, -0.1, 11.5).m_82542_(0.0625, 0.0625, 0.0625), new Vec3(3.0, -0.1, 2.5).m_82542_(0.0625, 0.0625, 0.0625)};
    }

    protected static enum RenderType {
        NORMAL,
        LECTERN;

    }
}

