/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.factoryBoard;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.UUID;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class FactoryPanelBlock
extends FaceAttachedHorizontalDirectionalBlock
implements ProperWaterloggedBlock,
IBE<FactoryPanelBlockEntity>,
IWrenchable,
SpecialBlockItemRequirement {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public FactoryPanelBlock(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_53179_, f_54117_, WATERLOGGED, POWERED}));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return FactoryPanelBlock.canAttachLenient(pLevel, pPos, FactoryPanelBlock.m_53200_((BlockState)pState).m_122424_());
    }

    public static boolean canAttachLenient(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        return !pReader.m_8055_(blockpos).m_60812_((BlockGetter)pReader, blockpos).m_83281_();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        if (stateForPlacement == null) {
            return null;
        }
        if (stateForPlacement.m_61143_((Property)f_53179_) == AttachFace.FLOOR) {
            stateForPlacement = (BlockState)stateForPlacement.m_61124_((Property)f_54117_, (Comparable)((Direction)stateForPlacement.m_61143_((Property)f_54117_)).m_122424_());
        }
        Level level = pContext.m_43725_();
        BlockPos pos = pContext.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        Vec3 location = pContext.m_43720_();
        if (blockState.m_60713_((Block)this) && location != null && fpbe != null) {
            if (!level.m_5776_()) {
                PanelSlot targetedSlot = FactoryPanelBlock.getTargetedSlot(pos, blockState, location);
                ItemStack panelItem = FactoryPanelBlockItem.fixCtrlCopiedStack(pContext.m_43722_());
                UUID networkFromStack = LogisticallyLinkedBlockItem.networkFromStack(panelItem);
                Player pPlayer = pContext.m_43723_();
                if (fpbe.addPanel(targetedSlot, networkFromStack) && pPlayer != null) {
                    pPlayer.m_5661_((Component)CreateLang.translateDirect("logistically_linked.connected", new Object[0]), true);
                    if (!pPlayer.m_7500_()) {
                        panelItem.m_41774_(1);
                        if (panelItem.m_41619_()) {
                            pPlayer.m_21008_(pContext.m_43724_(), ItemStack.f_41583_);
                        }
                    }
                }
            }
            stateForPlacement = blockState;
        }
        return this.withWater(stateForPlacement, pContext);
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        PanelSlot slot = FactoryPanelBlock.getTargetedSlot(pos, state, context.m_43720_());
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        return this.onBlockEntityUse((BlockGetter)world, pos, be -> {
            FactoryPanelBehaviour behaviour = be.panels.get((Object)slot);
            if (behaviour == null || !behaviour.isActive()) {
                return InteractionResult.SUCCESS;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, world.m_8055_(pos), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return InteractionResult.SUCCESS;
            }
            if (!be.removePanel(slot)) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_7500_()) {
                player.m_150109_().m_150079_(AllBlocks.FACTORY_GAUGE.asStack());
            }
            IWrenchable.playRemoveSound(world, pos);
            if (be.activePanels() == 0) {
                world.m_46961_(pos, false);
            }
            return InteractionResult.SUCCESS;
        });
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer == null) {
            return;
        }
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
        double range = pPlacer.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 1.0;
        HitResult hitResult = pPlacer.m_19907_(range, 1.0f, false);
        Vec3 location = hitResult.m_82450_();
        if (location == null) {
            return;
        }
        PanelSlot initialSlot = FactoryPanelBlock.getTargetedSlot(pPos, pState, location);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, fpbe -> fpbe.addPanel(initialSlot, LogisticallyLinkedBlockItem.networkFromStack(pStack)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        ItemStack item = pPlayer.m_21120_(pHand);
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!AllBlocks.FACTORY_GAUGE.isIn(item)) {
            return InteractionResult.SUCCESS;
        }
        Vec3 location = pHit.m_82450_();
        if (location == null) {
            return InteractionResult.SUCCESS;
        }
        if (!FactoryPanelBlockItem.isTuned(item)) {
            AllSoundEvents.DENY.playOnServer(pLevel, (Vec3i)pPos);
            pPlayer.m_5661_((Component)CreateLang.translate("factory_panel.tune_before_placing", new Object[0]).component(), true);
            return InteractionResult.FAIL;
        }
        PanelSlot newSlot = FactoryPanelBlock.getTargetedSlot(pPos, pState, location);
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, fpbe -> {
            if (!fpbe.addPanel(newSlot, LogisticallyLinkedBlockItem.networkFromStack(FactoryPanelBlockItem.fixCtrlCopiedStack(item)))) {
                return;
            }
            pPlayer.m_5661_((Component)CreateLang.translateDirect("logistically_linked.connected", new Object[0]), true);
            pLevel.m_247517_(null, pPos, this.f_60446_.m_56777_(), SoundSource.BLOCKS);
            if (pPlayer.m_7500_()) {
                return;
            }
            item.m_41774_(1);
            if (item.m_41619_()) {
                pPlayer.m_21008_(pHand, ItemStack.f_41583_);
            }
        });
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.tryDestroySubPanelFirst(state, level, pos, player)) {
            return false;
        }
        boolean result = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        return result;
    }

    private boolean tryDestroySubPanelFirst(BlockState state, Level level, BlockPos pos, Player player) {
        double range = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_() + 1.0;
        HitResult hitResult = player.m_19907_(range, 1.0f, false);
        Vec3 location = hitResult.m_82450_();
        PanelSlot destroyedSlot = FactoryPanelBlock.getTargetedSlot(pos, state, location);
        return InteractionResult.SUCCESS == this.onBlockEntityUse((BlockGetter)level, pos, fpbe -> {
            if (fpbe.activePanels() < 2) {
                return InteractionResult.FAIL;
            }
            if (!fpbe.removePanel(destroyedSlot)) {
                return InteractionResult.FAIL;
            }
            if (!player.m_7500_()) {
                FactoryPanelBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)AllBlocks.FACTORY_GAUGE.asStack());
            }
            return InteractionResult.SUCCESS;
        });
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.m_61143_((Property)POWERED) != false && FactoryPanelBlock.m_53200_((BlockState)pBlockState) == pSide ? 15 : 0;
    }

    public boolean m_6864_(BlockState pState, BlockPlaceContext pUseContext) {
        if (pUseContext.m_7078_()) {
            return false;
        }
        if (!AllBlocks.FACTORY_GAUGE.isIn(pUseContext.m_43722_())) {
            return false;
        }
        Vec3 location = pUseContext.m_43720_();
        if (location == null) {
            return false;
        }
        BlockPos pos = pUseContext.m_8083_();
        PanelSlot slot = FactoryPanelBlock.getTargetedSlot(pos, pState, location);
        FactoryPanelBlockEntity blockEntity = (FactoryPanelBlockEntity)this.getBlockEntity((BlockGetter)pUseContext.m_43725_(), pos);
        if (blockEntity == null) {
            return false;
        }
        return !blockEntity.panels.get((Object)slot).isActive();
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        EntityCollisionContext ecc;
        if (pContext instanceof EntityCollisionContext && (ecc = (EntityCollisionContext)pContext).m_193113_() == null) {
            return this.m_5940_(pState, pLevel, pPos, pContext);
        }
        return Shapes.m_83040_();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        FactoryPanelBlockEntity blockEntity = (FactoryPanelBlockEntity)this.getBlockEntity(pLevel, pPos);
        if (blockEntity != null) {
            return blockEntity.getShape();
        }
        return AllShapes.FACTORY_PANEL_FALLBACK.get(FactoryPanelBlock.m_53200_((BlockState)pState));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public FluidState m_5888_(BlockState pState) {
        return this.fluidState(pState);
    }

    public static Direction connectedDirection(BlockState state) {
        return FactoryPanelBlock.m_53200_((BlockState)state);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        IBE.onRemove(pState, pLevel, pPos, pNewState);
    }

    public static PanelSlot getTargetedSlot(BlockPos pos, BlockState blockState, Vec3 clickLocation) {
        double bestDistance = Double.MAX_VALUE;
        PanelSlot bestSlot = PanelSlot.BOTTOM_LEFT;
        Vec3 localClick = clickLocation.m_82546_(Vec3.m_82528_((Vec3i)pos));
        float xRot = 57.295776f * FactoryPanelBlock.getXRot(blockState);
        float yRot = 57.295776f * FactoryPanelBlock.getYRot(blockState);
        for (PanelSlot slot : PanelSlot.values()) {
            Vec3 vec = new Vec3(0.25 + (double)slot.xOffset * 0.5, 0.0, 0.25 + (double)slot.yOffset * 0.5);
            vec = VecHelper.rotateCentered((Vec3)vec, (double)180.0, (Direction.Axis)Direction.Axis.Y);
            vec = VecHelper.rotateCentered((Vec3)vec, (double)(xRot + 90.0f), (Direction.Axis)Direction.Axis.X);
            double diff = (vec = VecHelper.rotateCentered((Vec3)vec, (double)yRot, (Direction.Axis)Direction.Axis.Y)).m_82557_(localClick);
            if (diff > bestDistance) continue;
            bestDistance = diff;
            bestSlot = slot;
        }
        return bestSlot;
    }

    @Override
    public Class<FactoryPanelBlockEntity> getBlockEntityClass() {
        return FactoryPanelBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends FactoryPanelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.FACTORY_PANEL.get();
    }

    public static float getXRot(BlockState state) {
        AttachFace face = state.m_61145_((Property)f_53179_).orElse(AttachFace.FLOOR);
        return face == AttachFace.CEILING ? 1.5707964f : (face == AttachFace.FLOOR ? -1.5707964f : 0.0f);
    }

    public static float getYRot(BlockState state) {
        Direction facing = state.m_61145_((Property)f_54117_).orElse(Direction.SOUTH);
        AttachFace face = state.m_61145_((Property)f_53179_).orElse(AttachFace.FLOOR);
        return (face == AttachFace.CEILING ? (float)Math.PI : 0.0f) + AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing));
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return ItemRequirement.NONE;
    }

    public static enum PanelSlot {
        TOP_LEFT(1, 1),
        TOP_RIGHT(0, 1),
        BOTTOM_LEFT(1, 0),
        BOTTOM_RIGHT(0, 0);

        public int xOffset;
        public int yOffset;

        private PanelSlot(int xOffset, int yOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }
    }

    public static enum PanelType {
        NETWORK,
        PACKAGER;

    }

    public static enum PanelState {
        PASSIVE,
        ACTIVE;

    }
}

