/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.bonfire;

import java.time.Instant;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;

public class Bonfire
implements INBTSerializable<CompoundTag> {
    private String name;
    private UUID id;
    private UUID owner;
    private BlockPos pos;
    ResourceKey<Level> dimension;
    boolean isPublic;
    Instant timeCreated;

    public Bonfire(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public Bonfire(String name, UUID id, UUID owner, BlockPos pos, ResourceKey<Level> dimension, boolean isPublic, Instant timeCreated) {
        this.name = name;
        this.id = id;
        this.owner = owner;
        this.pos = pos;
        this.dimension = dimension;
        this.isPublic = isPublic;
        this.timeCreated = timeCreated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean aPublic) {
        this.isPublic = aPublic;
    }

    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    public void setTimeCreated(Instant timeCreated) {
        this.timeCreated = timeCreated;
    }

    public CompoundTag serializeNBT() {
        CompoundTag bonfireCompound = new CompoundTag();
        bonfireCompound.m_128362_("ID", this.getId());
        bonfireCompound.m_128359_("NAME", this.getName());
        bonfireCompound.m_128362_("OWNER", this.getOwner());
        bonfireCompound.m_128379_("PUBLIC", this.isPublic());
        bonfireCompound.m_128359_("DIM", this.getDimension().m_135782_().toString());
        bonfireCompound.m_128347_("POSX", (double)this.getPos().m_123341_());
        bonfireCompound.m_128347_("POSY", (double)this.getPos().m_123342_());
        bonfireCompound.m_128347_("POSZ", (double)this.getPos().m_123343_());
        CompoundTag timeCompound = new CompoundTag();
        timeCompound.m_128356_("SECOND", this.getTimeCreated().getEpochSecond());
        timeCompound.m_128405_("NANO", this.getTimeCreated().getNano());
        bonfireCompound.m_128365_("TIME", (Tag)timeCompound);
        return bonfireCompound;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.id = tag.m_128342_("ID");
        this.name = tag.m_128461_("NAME");
        this.owner = tag.m_128342_("OWNER");
        this.isPublic = tag.m_128471_("PUBLIC");
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("DIM")));
        this.pos = new BlockPos((int)tag.m_128459_("POSX"), (int)tag.m_128459_("POSY"), (int)tag.m_128459_("POSZ"));
        CompoundTag timeTag = tag.m_128469_("TIME");
        this.timeCreated = Instant.ofEpochSecond(timeTag.m_128454_("SECOND"), timeTag.m_128451_("NANO"));
    }
}

