/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client.gui.widgets;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.client.gui.BonfireScreen;

public class DimensionTabButton
extends Button {
    private BonfireScreen parent;
    private ResourceKey<Level> dimension;
    private int id;
    private Item icon = Items.f_42573_;

    public DimensionTabButton(BonfireScreen parent, int buttonId, int x, int y) {
        super(new Button.Builder((Component)Component.m_237119_(), b -> parent.action(buttonId)).m_252794_(x, y).m_253046_(28, 30));
        this.id = buttonId;
        this.parent = parent;
    }

    private Item getIcon() {
        if (this.icon == Items.f_42573_) {
            List<String> icons = BonfiresConfig.Client.tabIcons;
            for (String s : icons) {
                String[] split = s.split("=");
                if (split.length == 2) {
                    String dimID = split[0];
                    String item = split[1];
                    if (!dimID.equals(this.dimension.m_135782_().toString())) continue;
                    if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(item))) {
                        this.icon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item));
                        return this.icon;
                    }
                    return this.icon;
                }
                Bonfires.LOGGER.error(s + " is an invalid icon setting");
            }
        } else {
            return this.icon;
        }
        return this.icon;
    }

    public void setIcon(Item icon) {
        this.icon = icon;
    }

    void resetIcon() {
        this.icon = Items.f_42573_;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
        this.resetIcon();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            int tab_width = 28;
            int tab_height = 30;
            int tab_u = 28;
            int tab_v = this.parent.travel_height;
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.parent.dimTabSelected == this.id) {
                tab_v = this.parent.travel_height + 30;
                tab_height = 32;
                guiGraphics.m_280218_(this.parent.TRAVEL_TEX, this.m_252754_(), this.m_252907_(), tab_u, tab_v, tab_width, tab_height);
                guiGraphics.m_280203_(new ItemStack((ItemLike)this.getIcon(), 1), this.m_252754_() + tab_width / 2 - 8, this.m_252907_() + tab_height / 2 - 8);
            } else {
                guiGraphics.m_280218_(this.parent.TRAVEL_TEX, this.m_252754_(), this.m_252907_() - 1, tab_u, tab_v, tab_width, tab_height);
                guiGraphics.m_280203_(new ItemStack((ItemLike)this.getIcon(), 1), this.m_252754_() + tab_width / 2 - 8, this.m_252907_() + tab_height / 2 - 8 - 1);
            }
        }
    }
}

