/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client.gui.widgets;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.client.gui.ReinforceScreen;
import wehavecookies56.bonfires.data.ReinforceHandler;
import wehavecookies56.bonfires.setup.ItemSetup;

public class ReinforceItemButton
extends Button {
    ReinforceScreen parent;

    public ReinforceItemButton(ReinforceScreen parent, int buttonId, int x, int y, int widthIn, int heightIn) {
        super(new Button.Builder((Component)Component.m_237119_(), button -> parent.action(buttonId)).m_252794_(x, y).m_253046_(widthIn, heightIn));
        this.parent = parent;
    }

    public void drawItem(ItemStack istack, GuiGraphics guiGraphics, int x, int y, int scale) {
        if (!istack.m_41619_()) {
            BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(istack, (Level)Minecraft.m_91087_().f_91073_, (LivingEntity)Minecraft.m_91087_().f_91074_, 0);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)(x + 16), (float)(y + 16), 150.0f);
            try {
                boolean flag;
                guiGraphics.m_280168_().m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
                guiGraphics.m_280168_().m_85841_(16.0f * (float)scale, 16.0f * (float)scale, 16.0f * (float)scale);
                boolean bl = flag = !bakedmodel.m_7547_();
                if (flag) {
                    Lighting.m_84930_();
                }
                Minecraft.m_91087_().m_91291_().m_115143_(istack, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
                guiGraphics.m_280262_();
                if (flag) {
                    Lighting.m_84931_();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
                crashreportcategory.m_128165_("Item Type", () -> String.valueOf(istack.m_41720_()));
                crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)istack.m_41720_())));
                crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(istack.m_41773_()));
                crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(istack.m_41783_()));
                crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(istack.m_41790_()));
                throw new ReportedException(crashreport);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void drawButtons(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, float scrollOffset) {
        if (this.f_93624_) {
            int i;
            Minecraft mc = Minecraft.m_91087_();
            double scale = mc.m_91268_().m_85449_();
            int scissorX = this.m_252754_();
            int scissorY = this.m_252907_();
            int scissorWidth = 239;
            int scissorHeight = 171;
            RenderSystem.enableScissor((int)0, (int)(mc.m_91268_().m_85442_() - (int)((double)(scissorY + scissorHeight) * scale)), (int)mc.m_91268_().m_85441_(), (int)((int)((double)scissorHeight * scale)));
            int insideWidth = this.m_252754_() + this.f_93618_;
            if (this.parent.scrollBar.f_93624_) {
                insideWidth -= 8;
            }
            int elementHeight = 36;
            for (i = 0; i < this.parent.reinforceableItems.size(); ++i) {
                if (i % 2 == 0) continue;
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.5f);
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() - (int)scrollOffset + elementHeight * i, insideWidth, (int)((float)this.m_252907_() - scrollOffset + (float)elementHeight + (float)(elementHeight * i)), new Color(44, 49, 43).getRGB());
                guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.parent.itemSelected != -1) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() - (int)scrollOffset + elementHeight * this.parent.itemSelected, insideWidth, (int)((float)this.m_252907_() - scrollOffset + (float)elementHeight + (float)(elementHeight * this.parent.itemSelected)), new Color(160, 160, 160).getRGB());
                guiGraphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1 - (int)scrollOffset + elementHeight * this.parent.itemSelected, insideWidth - 1, (int)((float)this.m_252907_() - scrollOffset + (float)elementHeight + (float)(elementHeight * this.parent.itemSelected) - 1.0f), new Color(0, 0, 0).getRGB());
            }
            for (i = 0; i < this.parent.reinforceableItems.size(); ++i) {
                float yPos = (float)(this.m_252907_() + 2) + ((float)(36 * i) - scrollOffset);
                this.drawItem(this.parent.reinforceableItems.get(i), guiGraphics, this.m_252754_() + 2, (int)yPos, 2);
                ItemStack item = this.parent.reinforceableItems.get(i);
                int nextLevel = ReinforceHandler.getReinforceLevel(item).level() + 1;
                String nextLevelText = Integer.toString(nextLevel);
                Object itemName = this.parent.reinforceableItems.get(i).m_41786_().getString();
                if (ReinforceHandler.getReinforceLevel(item).level() > 0) {
                    itemName = (String)itemName + " +" + ReinforceHandler.getReinforceLevel(item).level();
                }
                double currentDamage = 0.0;
                double nextDamage = 0.0;
                currentDamage = BonfiresConfig.Server.reinforceDamagePerLevel * (double)ReinforceHandler.getReinforceLevel(item).level();
                nextDamage = currentDamage + BonfiresConfig.Server.reinforceDamagePerLevel;
                MutableComponent upgradeText = Component.m_237115_((String)"text.bonfires.reinforce.attack");
                if (item.m_150930_((Item)ItemSetup.estus_flask.get())) {
                    currentDamage = BonfiresConfig.Server.estusFlaskBaseHeal;
                    nextDamage = currentDamage += BonfiresConfig.Server.estusFlaskHealPerLevel * (double)ReinforceHandler.getReinforceLevel(item).level();
                    nextDamage += BonfiresConfig.Server.estusFlaskHealPerLevel;
                    currentDamage /= 2.0;
                    nextDamage /= 2.0;
                    upgradeText = Component.m_237115_((String)"text.bonfires.reinforce.heal");
                }
                MutableComponent next = Component.m_237113_((String)("+" + nextLevelText));
                if (nextLevel - 1 == ReinforceHandler.getReinforceLevel(item).maxLevel()) {
                    next = Component.m_237115_((String)"text.bonfires.reinforce.max");
                }
                Font font = mc.f_91062_;
                String string = (String)itemName + " > " + next.getString();
                int n = this.m_252754_() + 2 + 34;
                int n2 = (int)yPos + 16;
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280488_(font, string, n, n2 - 9 / 2, new Color(255, 255, 255).getRGB());
                MutableComponent damageText = nextLevel - 1 == ReinforceHandler.getReinforceLevel(item).maxLevel() ? Component.m_237115_((String)"text.bonfires.reinforce.max") : Component.m_237113_((String)("+" + nextDamage));
                Font font2 = mc.f_91062_;
                int n3 = (int)yPos + 8;
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280653_(font2, (Component)upgradeText, insideWidth - 35, n3 - 9 / 2, new Color(255, 255, 255).getRGB());
                Font font3 = mc.f_91062_;
                String string2 = "+" + currentDamage + " > " + damageText.getString();
                int n4 = (int)yPos + 24;
                Objects.requireNonNull(mc.f_91062_);
                guiGraphics.m_280488_(font3, string2, insideWidth - 60, n4 - 9 / 2, new Color(255, 255, 255).getRGB());
            }
            RenderSystem.disableScissor();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
    }

    public boolean mousePressed(Minecraft mc, double mouseX, double mouseY, float scrollOffset) {
        int minusWidth = 0;
        if (this.parent.scrollBar.f_93624_) {
            minusWidth -= 8;
        }
        if (this.f_93624_ && this.f_93623_ && mouseX >= (double)this.m_252754_() && mouseX <= (double)(this.m_252754_() + this.f_93618_ + minusWidth) && mouseY >= (double)this.m_252907_() && mouseY <= (double)(this.m_252907_() + this.f_93619_)) {
            double truePos = mouseY - (double)this.m_252907_() + (double)scrollOffset;
            int index = (int)truePos / 36;
            if (this.parent.reinforceableItems.size() - 1 >= index) {
                this.parent.itemSelected = (int)truePos / 36;
                this.m_7435_(mc.m_91106_());
            }
        }
        return true;
    }
}

