/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;
import wehavecookies56.bonfires.blocks.AshBonePileBlock;
import wehavecookies56.bonfires.client.ScreenshotUtils;
import wehavecookies56.bonfires.setup.BlockSetup;
import wehavecookies56.bonfires.setup.ItemSetup;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class BonfireRenderer
implements BlockEntityRenderer<BonfireTileEntity> {
    BlockEntityRendererProvider.Context context;

    public BonfireRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(BonfireTileEntity te, float pPartialTicks, PoseStack stack, MultiBufferSource pBuffer, int pCombinedLight, int pCombinedOverlay) {
        if (te.isBonfire()) {
            stack.m_85836_();
            stack.m_85837_(0.5, 0.65, 0.5);
            if (Minecraft.m_91087_().f_91073_.m_8055_(te.m_58899_()).m_60734_() == BlockSetup.ash_bone_pile.get()) {
                if (Minecraft.m_91087_().f_91073_.m_8055_(te.m_58899_()).m_61143_((Property)AshBonePileBlock.FACING) == Direction.NORTH) {
                    stack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                } else if (Minecraft.m_91087_().f_91073_.m_8055_(te.m_58899_()).m_61143_((Property)AshBonePileBlock.FACING) == Direction.EAST) {
                    stack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                } else if (Minecraft.m_91087_().f_91073_.m_8055_(te.m_58899_()).m_61143_((Property)AshBonePileBlock.FACING) == Direction.SOUTH) {
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                } else if (Minecraft.m_91087_().f_91073_.m_8055_(te.m_58899_()).m_61143_((Property)AshBonePileBlock.FACING) == Direction.WEST) {
                    stack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                }
            }
            stack.m_252781_(Axis.f_252403_.m_252977_(-130.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)ItemSetup.coiled_sword.get()), ItemDisplayContext.NONE, pCombinedLight, pCombinedOverlay, stack, pBuffer, (Level)Minecraft.m_91087_().f_91073_, 0);
            stack.m_85849_();
            if (te.isLit() && !ScreenshotUtils.isTakingScreenshot()) {
                this.renderNameTag(te, te.getDisplayName(), stack, pBuffer, pCombinedLight, pPartialTicks);
            }
        }
    }

    protected void renderNameTag(BonfireTileEntity te, Component pDisplayName, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, float partialTicks) {
        if (!pDisplayName.getString().isEmpty() && this.lookingAt(partialTicks, te)) {
            float f = (float)(te.m_58900_().m_60812_((BlockGetter)Minecraft.m_91087_().f_91073_, te.m_58899_()).m_83297_(Direction.Axis.Y) + 0.5);
            pMatrixStack.m_85836_();
            pMatrixStack.m_85837_(0.5, (double)f, 0.5);
            pMatrixStack.m_252781_(this.context.m_173581_().f_112249_.m_253121_());
            pMatrixStack.m_85841_(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = pMatrixStack.m_85850_().m_252922_();
            float f1 = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
            int j = (int)(f1 * 255.0f) << 24;
            Font fontrenderer = this.context.m_173586_();
            float f2 = -fontrenderer.m_92852_((FormattedText)pDisplayName) / 2;
            fontrenderer.m_272077_(pDisplayName, f2, 0.0f, 0x20FFFFFF, false, matrix4f, pBuffer, Font.DisplayMode.NORMAL, j, pPackedLight);
            fontrenderer.m_272077_(pDisplayName, f2, 0.0f, -1, false, matrix4f, pBuffer, Font.DisplayMode.NORMAL, 0, pPackedLight);
            pMatrixStack.m_85849_();
        }
    }

    boolean lookingAt(float partialTicks, BonfireTileEntity te) {
        HitResult rayTraceResult = Minecraft.m_91087_().f_91074_.m_19907_(20.0, partialTicks, false);
        return ((BlockHitResult)rayTraceResult).m_82425_().equals((Object)te.m_58899_());
    }
}

