/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;

public class BonfireHandler {
    public static final Capability<IBonfireHandler> CAPABILITY_BONFIRE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IBonfireHandler>(){});

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new BonfireHandler());
    }

    @SubscribeEvent
    public static void register(RegisterCapabilitiesEvent event) {
        event.register(IBonfireHandler.class);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Level> event) {
        event.addCapability(new ResourceLocation("bonfires", "bonfire"), (ICapabilityProvider)new Provider());
    }

    public static IBonfireHandler getHandler(Level world) {
        LazyOptional bonfireHandler = world.getCapability(CAPABILITY_BONFIRE, null);
        return (IBonfireHandler)bonfireHandler.orElse(null);
    }

    public static IBonfireHandler getServerHandler(MinecraftServer server) {
        return BonfireHandler.getHandler((Level)server.m_129783_());
    }

    public static interface IBonfireHandler
    extends INBTSerializable<CompoundTag> {
        public BonfireRegistry getRegistry();

        public boolean addBonfire(Bonfire var1);

        public boolean removeBonfire(UUID var1);
    }

    public static class Provider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        IBonfireHandler instance = new Default();

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY_BONFIRE.orEmpty(cap, LazyOptional.of(() -> this.instance));
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.instance.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.instance.deserializeNBT((Tag)nbt);
        }
    }

    public static class Default
    implements IBonfireHandler {
        BonfireRegistry registry = new BonfireRegistry();

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            this.getRegistry().writeToNBT(tag, this.getRegistry().getBonfires());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.getRegistry().readFromNBT(tag, this.getRegistry().getBonfires());
        }

        @Override
        public BonfireRegistry getRegistry() {
            return this.registry;
        }

        @Override
        public boolean addBonfire(Bonfire bonfire) {
            return this.registry.addBonfire(bonfire);
        }

        @Override
        public boolean removeBonfire(UUID id) {
            return this.registry.removeBonfire(id);
        }
    }
}

