/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.client.ClientPacketHandler;
import wehavecookies56.bonfires.packets.Packet;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class OpenBonfireGUI
extends Packet<OpenBonfireGUI> {
    public BlockPos tileEntity;
    public Map<UUID, String> ownerNames;
    public BonfireRegistry registry;
    public List<ResourceKey<Level>> dimensions;
    public boolean canReinforce;

    public OpenBonfireGUI(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public OpenBonfireGUI(BonfireTileEntity bonfire, Map<UUID, String> ownerNames, BonfireRegistry registry, boolean canReinforce) {
        this.ownerNames = ownerNames;
        this.tileEntity = bonfire.m_58899_();
        this.registry = registry;
        this.dimensions = new ArrayList<ResourceKey<Level>>(ServerLifecycleHooks.getCurrentServer().m_129784_());
        this.canReinforce = canReinforce;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        this.canReinforce = buffer.readBoolean();
        CompoundTag owners = buffer.m_130260_();
        this.ownerNames = new HashMap<UUID, String>();
        owners.m_128431_().forEach(s -> this.ownerNames.put(UUID.fromString(s), owners.m_128461_(s)));
        this.tileEntity = buffer.m_130135_();
        this.registry = new BonfireRegistry();
        this.registry.readFromNBT(buffer.m_130260_(), this.registry.getBonfires());
        this.dimensions = new ArrayList<ResourceKey<Level>>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.dimensions.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_()));
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.canReinforce);
        CompoundTag owners = new CompoundTag();
        this.ownerNames.forEach((uuid, s) -> owners.m_128359_(uuid.toString(), s));
        buffer.m_130079_(owners);
        buffer.m_130064_(this.tileEntity);
        buffer.m_130079_(this.registry.writeToNBT(new CompoundTag(), this.registry.getBonfires()));
        buffer.m_130130_(this.dimensions.size());
        for (int i = 0; i < this.dimensions.size(); ++i) {
            buffer.m_130085_(this.dimensions.get(i).m_135782_());
        }
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientPacketHandler.openBonfire(this));
    }
}

