/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.client;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import wehavecookies56.bonfires.client.ClientPacketHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.packets.Packet;

public class SyncDiscoveryData
extends Packet<SyncDiscoveryData> {
    Map<UUID, Instant> discovered;

    public SyncDiscoveryData(FriendlyByteBuf buffer) {
        super(buffer);
    }

    public SyncDiscoveryData(DiscoveryHandler.IDiscoveryHandler handler) {
        this.discovered = handler.getDiscovered();
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        if (size > 0) {
            this.discovered = new HashMap<UUID, Instant>();
            CompoundTag tag = buffer.m_130260_();
            tag.m_128431_().forEach(uuidString -> {
                CompoundTag timeTag = tag.m_128469_(uuidString);
                this.discovered.put(UUID.fromString(uuidString), Instant.ofEpochSecond(timeTag.m_128454_("epoch"), timeTag.m_128451_("nano")));
            });
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.discovered.size());
        CompoundTag tag = new CompoundTag();
        this.discovered.forEach((uuid, instant) -> {
            CompoundTag timeTag = new CompoundTag();
            timeTag.m_128356_("epoch", instant.getEpochSecond());
            timeTag.m_128405_("nano", instant.getNano());
            tag.m_128365_(uuid.toString(), (Tag)timeTag);
            buffer.m_130079_(tag);
        });
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientPacketHandler.syncDiscoveryData(this.discovered));
    }
}

