/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.tiles;

import java.time.Instant;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wehavecookies56.bonfires.BonfiresConfig;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.setup.EntitySetup;

public class BonfireTileEntity
extends BlockEntity {
    private boolean bonfire = false;
    private boolean lit = false;
    private UUID id = UUID.randomUUID();
    private boolean unlitPrivate = false;
    private String unlitName;
    private BonfireType type = BonfireType.NONE;

    public BonfireTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntitySetup.BONFIRE.get(), pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.bonfire = compound.m_128471_("bonfire");
        this.type = BonfireType.values()[compound.m_128451_("type")];
        this.lit = compound.m_128471_("lit");
        this.id = compound.m_128342_("bonfire_id");
        if (compound.m_128441_("unlit")) {
            CompoundTag unlit = compound.m_128469_("unlit");
            this.setNameInternal(unlit.m_128461_("name"));
            this.unlitPrivate = unlit.m_128471_("private");
        }
    }

    protected void m_183515_(CompoundTag compound) {
        compound.m_128379_("bonfire", this.bonfire);
        compound.m_128405_("type", this.type.ordinal());
        compound.m_128379_("lit", this.lit);
        compound.m_128362_("bonfire_id", this.id);
        if (this.unlitName != null && !this.unlitName.isEmpty()) {
            CompoundTag unlit = new CompoundTag();
            unlit.m_128359_("name", this.unlitName);
            unlit.m_128379_("private", this.unlitPrivate);
            compound.m_128365_("unlit", (Tag)unlit);
        }
        super.m_183515_(compound);
    }

    public Bonfire createBonfire(String name, UUID id, UUID owner, boolean isPublic) {
        Bonfire bonfire = new Bonfire(name, id, owner, this.m_58899_(), (ResourceKey<Level>)this.f_58857_.m_46472_(), isPublic, Instant.now());
        BonfireHandler.getServerHandler(this.f_58857_.m_7654_()).addBonfire(bonfire);
        return bonfire;
    }

    public void destroyBonfire(UUID id) {
        BonfireHandler.getHandler(this.f_58857_).removeBonfire(id);
    }

    public boolean isBonfire() {
        return this.bonfire;
    }

    public BonfireType getBonfireType() {
        return this.type;
    }

    public void setBonfireType(BonfireType type) {
        this.type = type;
        this.m_6596_();
    }

    public void setBonfire(boolean bonfire) {
        this.bonfire = bonfire;
        this.m_6596_();
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
        this.m_6596_();
    }

    public UUID getID() {
        return this.id;
    }

    public void setID(UUID id) {
        this.id = id;
        this.m_6596_();
    }

    private void setNameInternal(String name) {
        this.unlitName = name.substring(0, Math.min(name.length(), 14));
    }

    public void setUnlitName(String name) {
        this.setNameInternal(name);
        this.m_6596_();
    }

    public String getUnlitName() {
        return this.unlitName;
    }

    public void setUnlitPrivate(boolean unlitPrivate) {
        this.unlitPrivate = unlitPrivate;
        this.m_6596_();
    }

    public boolean isUnlitPrivate() {
        return this.unlitPrivate;
    }

    public boolean hasUnlitName() {
        return this.unlitName != null && !this.unlitName.isEmpty();
    }

    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDisplayName() {
        Bonfire bonfire;
        if (!Minecraft.m_91087_().f_91074_.m_6047_() && this.getID() != null && BonfiresConfig.Client.renderTextAboveBonfire && (bonfire = BonfireHandler.getHandler((Level)Minecraft.m_91087_().f_91073_).getRegistry().getBonfire(this.getID())) != null) {
            if (bonfire.isPublic()) {
                return Component.m_237115_((String)bonfire.getName());
            }
            return Component.m_237110_((String)"tileentity.bonfires.bonfire.label", (Object[])new Object[]{bonfire.getName()});
        }
        return Component.m_237119_();
    }

    public static enum BonfireType {
        BONFIRE,
        PRIMAL,
        NONE;

    }
}

