/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.narrow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class NarrowDoubleScotchYokeBogeyVisual
implements BogeyVisual {
    private final TransformedInstance frame;
    private final TransformedInstance pistons;
    private final TransformedInstance[] wheels = new TransformedInstance[2];
    private final TransformedInstance[] wheelPins = new TransformedInstance[2];
    private final TransformedInstance[] primaryShafts = new TransformedInstance[2];
    private final TransformedInstance[] secondaryShafts = new TransformedInstance[2];

    public NarrowDoubleScotchYokeBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_DOUBLE_SCOTCH_FRAME)).createInstance();
        this.pistons = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_DOUBLE_SCOTCH_PISTONS)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_WHEELS)).createInstances((Instance[])this.wheels);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_SCOTCH_WHEEL_PINS)).createInstances((Instance[])this.wheelPins);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.primaryShafts);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.secondaryShafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int i : Iterate.zeroAndOne) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.primaryShafts[i].translate(-0.5, 0.0625, 0.4375 + (double)i * -1.875)).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        for (int i : Iterate.zeroAndOne) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.secondaryShafts[i].translate(-0.5, 0.375, 1.125 + (double)i * -3.25)).center()).rotateXDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.translate(0.0f, 0.3125f, 0.0f).setChanged();
        ((TransformedInstance)this.pistons.translate(0.0, 0.875, 0.25 * Math.sin(AngleHelper.rad((double)wheelAngle)))).setChanged();
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)((TransformedInstance)this.wheels[(side + 1) / 2].translate(0.0, 0.875, (double)side * 0.75)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.0f, 0.0f).setChanged();
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.wheelPins[(side + 1) / 2].translate(0.0, 0.875, (double)side * 0.75)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.25f, 0.0f).rotateXDegrees(-wheelAngle)).setChanged();
        }
    }

    public void hide() {
        this.frame.setZeroTransform().setChanged();
        this.pistons.setZeroTransform().setChanged();
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
        for (TransformedInstance pin : this.wheelPins) {
            pin.setZeroTransform().setChanged();
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        this.frame.light(packedLight);
        this.pistons.light(packedLight);
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        for (TransformedInstance pin : this.wheelPins) {
            pin.light(packedLight);
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.frame);
        consumer.accept((Instance)this.pistons);
        for (TransformedInstance shaft : this.primaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        for (TransformedInstance pin : this.wheelPins) {
            consumer.accept((Instance)pin);
        }
    }

    public void delete() {
        this.frame.delete();
        this.pistons.delete();
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        for (TransformedInstance pin : this.wheelPins) {
            pin.delete();
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.delete();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.delete();
        }
    }
}

