/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.narrow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class NarrowSmallBogeyVisual
implements BogeyVisual {
    private final TransformedInstance frame;
    private final TransformedInstance[] shafts = new TransformedInstance[2];
    private final TransformedInstance[] wheels = new TransformedInstance[4];

    public NarrowSmallBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_WHEELS)).createInstances((Instance[])this.wheels);
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.NARROW_FRAME)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstances((Instance[])this.shafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int i : Iterate.zeroAndOne) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shafts[i].translate(-0.5, 0.0625, -1.125 + (double)(i * 12) / 16.0)).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.translate(0.0f, 0.3125f, 0.0f).setChanged();
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.wheels[(side + 1) / 2].translate(0.0, 0.6875, (double)side * 0.625)).rotateXDegrees(wheelAngle)).uncenter()).setChanged();
        }
    }

    public void hide() {
        this.frame.setZeroTransform().setChanged();
        for (TransformedInstance shaft : this.shafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        this.frame.light(packedLight);
        for (TransformedInstance shaft : this.shafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.frame);
        for (TransformedInstance shaft : this.shafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
    }

    public void delete() {
        this.frame.delete();
        for (TransformedInstance shaft : this.shafts) {
            shaft.delete();
        }
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
    }
}

