/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.double_axle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class ModernBogeyVisual
implements BogeyVisual {
    private final TransformedInstance[] wheels = new TransformedInstance[2];
    private final TransformedInstance frame;

    public ModernBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MODERN_FRAME)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LONG_SHAFTED_WHEELS)).createInstances((Instance[])this.wheels);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int side = -1; side < 2; ++side) {
            ((TransformedInstance)this.wheels[side + 1].translate(0.0f, 0.75f, (float)side).rotateXDegrees(wheelAngle)).translate(0.0f, -0.75f, 0.0f).setChanged();
        }
        this.frame.setChanged();
    }

    public void hide() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
        this.frame.setZeroTransform().setChanged();
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        this.frame.light(packedLight);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        consumer.accept((Instance)this.frame);
    }

    public void delete() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        this.frame.delete();
    }
}

