/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.large;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class LargeCreateStyled060Visual
implements BogeyVisual {
    private final TransformedInstance frame;
    private final TransformedInstance piston;
    private final TransformedInstance secondaryWheel;
    private final TransformedInstance[] wheels = new TransformedInstance[2];
    private final TransformedInstance[] pins = new TransformedInstance[3];
    private final TransformedInstance[] primaryShafts = new TransformedInstance[2];
    private final TransformedInstance[] secondaryShafts = new TransformedInstance[4];

    public LargeCreateStyled060Visual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LARGE_CREATE_STYLED_0_6_0_FRAME)).createInstance();
        this.piston = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LARGE_CREATE_STYLED_0_6_0_PISTON)).createInstance();
        this.secondaryWheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LC_STYLE_SEMI_BLIND_WHEELS)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.LARGE_BOGEY_WHEELS)).createInstances((Instance[])this.wheels);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.BOGEY_PIN)).createInstances((Instance[])this.pins);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.primaryShafts);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.secondaryShafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.primaryShafts[(side + 1) / 2].translate(-0.5, 0.25, -0.5 + (double)side * 1.87)).center()).rotateXDegrees(wheelAngle)).uncenter()).setChanged();
        }
        for (int side = -2; side < 3; ++side) {
            if (side == 0) continue;
            int shaftNum = side > 0 ? side + 1 : side + 2;
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.secondaryShafts[shaftNum].translate(-0.5f, 0.25f, -0.5f + (float)side).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.setChanged();
        ((TransformedInstance)this.piston.translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad((double)wheelAngle)))).setChanged();
        ((TransformedInstance)this.secondaryWheel.translate(0.0f, 1.0f, 0.0f).rotateXDegrees(wheelAngle)).translate(0.0f, -1.0f, 0.0f).setChanged();
        for (int side : Iterate.positiveAndNegative) {
            ((TransformedInstance)((TransformedInstance)this.wheels[(side + 1) / 2].translate(0.0, 1.0, (double)side * 1.6842)).rotateXDegrees(wheelAngle)).translate(0.0f, -0.8125f, 0.0f).setChanged();
        }
        for (int side = -1; side < 2; ++side) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pins[side + 1].translate(0.0, 1.0, (double)side * 1.6842)).rotateXDegrees(wheelAngle)).translate(0.0f, 0.25f, 0.0f).rotateXDegrees(-wheelAngle)).setChanged();
        }
    }

    public void hide() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.setZeroTransform().setChanged();
        }
        this.frame.setZeroTransform().setChanged();
        this.piston.setZeroTransform().setChanged();
        this.secondaryWheel.setZeroTransform().setChanged();
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.setZeroTransform().setChanged();
        }
        for (TransformedInstance pin : this.pins) {
            pin.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        for (TransformedInstance wheel : this.wheels) {
            wheel.light(packedLight);
        }
        this.frame.light(packedLight);
        this.piston.light(packedLight);
        this.secondaryWheel.light(packedLight);
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.light(packedLight);
        }
        for (TransformedInstance pin : this.pins) {
            pin.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        for (TransformedInstance wheel : this.wheels) {
            consumer.accept((Instance)wheel);
        }
        consumer.accept((Instance)this.frame);
        consumer.accept((Instance)this.piston);
        consumer.accept((Instance)this.secondaryWheel);
        for (TransformedInstance shaft : this.primaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance shaft : this.primaryShafts) {
            consumer.accept((Instance)shaft);
        }
        for (TransformedInstance pin : this.pins) {
            consumer.accept((Instance)pin);
        }
    }

    public void delete() {
        for (TransformedInstance wheel : this.wheels) {
            wheel.delete();
        }
        this.frame.delete();
        this.piston.delete();
        this.secondaryWheel.delete();
        for (TransformedInstance shaft : this.primaryShafts) {
            shaft.delete();
        }
        for (TransformedInstance shaft : this.secondaryShafts) {
            shaft.delete();
        }
        for (TransformedInstance pin : this.pins) {
            pin.delete();
        }
    }
}

