/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.medium;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class MediumSingleWheelVisual
implements BogeyVisual {
    private final TransformedInstance wheel;
    private final TransformedInstance frame;
    private final TransformedInstance[] shafts = new TransformedInstance[2];

    public MediumSingleWheelVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MEDIUM_SINGLE_WHEEL_FRAME)).createInstance();
        this.wheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MEDIUM_SHARED_WHEELS)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.shafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        for (int i : Iterate.zeroAndOne) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.shafts[i].translate(-0.5f, 0.25f, (float)(i * -1)).center()).rotateZDegrees(wheelAngle)).uncenter()).setChanged();
        }
        this.frame.setChanged();
        ((TransformedInstance)this.wheel.translate(0.0f, 0.75f, 0.0f).rotateXDegrees(wheelAngle)).translate(0.0f, -0.8125f, 0.0f).setChanged();
    }

    public void hide() {
        this.wheel.setZeroTransform().setChanged();
        this.frame.setZeroTransform().setChanged();
        for (TransformedInstance shaft : this.shafts) {
            shaft.setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        this.wheel.light(packedLight);
        this.frame.light(packedLight);
        for (TransformedInstance shaft : this.shafts) {
            shaft.light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.wheel);
        consumer.accept((Instance)this.frame);
        for (TransformedInstance shaft : this.shafts) {
            consumer.accept((Instance)shaft);
        }
    }

    public void delete() {
        this.wheel.delete();
        this.frame.delete();
        for (TransformedInstance shaft : this.shafts) {
            shaft.delete();
        }
    }
}

