/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.renderer.standard.single_axle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class LeafspringBogeyVisual
implements BogeyVisual {
    private final TransformedInstance frame;
    private final TransformedInstance wheel;
    private final boolean inContraption;

    public LeafspringBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.inContraption = inContraption;
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.LEAFSPRING_FRAME)).createInstance();
        this.wheel = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SMALL_BOGEY_WHEELS)).createInstance();
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        ((TransformedInstance)this.wheel.translate(0.0f, 0.75f, 0.0f).rotateXDegrees(wheelAngle)).setChanged();
        this.frame.setChanged();
    }

    public void hide() {
        this.frame.setZeroTransform().setChanged();
        this.wheel.setZeroTransform().setChanged();
    }

    public void updateLight(int packedLight) {
        this.frame.light(packedLight);
        this.wheel.light(packedLight);
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.frame);
        consumer.accept((Instance)this.wheel);
    }

    public void delete() {
        this.frame.delete();
        this.wheel.delete();
    }
}

