/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_bogeys.special.monobogey;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.trains.bogey.BogeyVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class MonoBogeyVisual
implements BogeyVisual {
    private final TransformedInstance frame;
    private final TransformedInstance[] wheels = new TransformedInstance[4];
    private final TransformedInstance[] shafts = new TransformedInstance[4];
    private final boolean inContraption;

    public MonoBogeyVisual(VisualizationContext ctx, float partialTick, boolean inContraption) {
        this.inContraption = inContraption;
        this.frame = (TransformedInstance)ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MONOBOGEY_FRAME)).createInstance();
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CRBlockPartials.MONOBOGEY_WHEEL)).createInstances((Instance[])this.wheels);
        ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstances((Instance[])this.shafts);
    }

    public void update(CompoundTag bogeyData, float wheelAngle, PoseStack poseStack) {
        boolean upsideDown = bogeyData.m_128471_("UpsideDown");
        boolean specialUpsideDown = !this.inContraption && upsideDown;
        ((TransformedInstance)((TransformedInstance)this.frame.rotateYDegrees(specialUpsideDown ? 180.0f : 0.0f)).translateY(specialUpsideDown ? -3.0f : 0.0f)).setChanged();
        for (boolean left : Iterate.trueAndFalse) {
            for (int front : Iterate.positiveAndNegative) {
                int i = (left ? 1 : 0) + (front + 1);
                TransformedInstance shaft = this.shafts[i];
                ((TransformedInstance)((TransformedInstance)((TransformedInstance)shaft.translate(left ? -1.3125f : 0.3125f, specialUpsideDown ? 2.0f : 0.0f, -0.5f + (float)(front * 8) / 16.0f).center()).rotateZDegrees(left ? wheelAngle : -wheelAngle)).uncenter()).setChanged();
                TransformedInstance wheel = this.wheels[i];
                ((TransformedInstance)wheel.translate(left ? -0.8125f : 0.8125f, specialUpsideDown ? 2.0f : 0.0f, (float)(front * 16) / 16.0f).rotateYDegrees(left ? wheelAngle : -wheelAngle)).translate(0.8125f, 0.0f, 1.0f).setChanged();
            }
        }
    }

    public void hide() {
        for (int i = 0; i <= 3; ++i) {
            this.wheels[i].setZeroTransform().setChanged();
            this.shafts[i].setZeroTransform().setChanged();
        }
    }

    public void updateLight(int packedLight) {
        this.frame.light(packedLight);
        for (int i = 0; i <= 3; ++i) {
            this.wheels[i].light(packedLight);
            this.shafts[i].light(packedLight);
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.frame);
        for (int i = 0; i <= 3; ++i) {
            consumer.accept((Instance)this.wheels[i]);
            consumer.accept((Instance)this.shafts[i]);
        }
    }

    public void delete() {
        this.frame.delete();
        for (int i = 0; i <= 3; ++i) {
            this.wheels[i].delete();
            this.shafts[i].delete();
        }
    }
}

