/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.generic_crossing;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.custom_tracks.generic_crossing.GenericCrossingBlockEntity;
import com.railwayteam.railways.registry.CRBlockEntities;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackPropagator;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.Affine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GenericCrossingBlock
extends Block
implements IBE<GenericCrossingBlockEntity>,
ITrackBlock,
IWrenchable,
SpecialBlockItemRequirement,
ProperWaterloggedBlock {
    public static final EnumProperty<TrackShape> SHAPE = TrackBlock.SHAPE;

    public GenericCrossingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)TrackShape.CR_O)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return this.fluidState(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.withWater(super.m_5573_(context), context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    public Vec3 getUpNormal(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TrackShape)state.m_61143_(SHAPE)).getNormal();
    }

    public List<Vec3> getTrackAxes(BlockGetter world, BlockPos pos, BlockState state) {
        return ((TrackShape)state.m_61143_(SHAPE)).getAxes();
    }

    public Vec3 getCurveStart(BlockGetter world, BlockPos pos, BlockState state, Vec3 axis) {
        boolean vertical = axis.f_82480_ != 0.0;
        return VecHelper.getCenterOf((Vec3i)pos).m_82520_(0.0, (double)(vertical ? 0.0f : -0.5f), 0.0).m_82549_(axis.m_82490_(0.5));
    }

    public BlockState getBogeyAnchor(BlockGetter world, BlockPos pos, BlockState state) {
        return Blocks.f_50016_.m_49966_();
    }

    public boolean trackEquals(BlockState state1, BlockState state2) {
        return false;
    }

    public <Self extends Affine<Self>> PartialModel prepareTrackOverlay(Affine<Self> affine, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, BezierTrackPointLocation bezierTrackPointLocation, Direction.AxisDirection axisDirection, TrackTargetingBehaviour.RenderedTrackOverlayType renderedTrackOverlayType) {
        return ((TrackBlock)AllBlocks.TRACK.get()).prepareTrackOverlay(affine, blockGetter, blockPos, blockState, bezierTrackPointLocation, axisDirection, renderedTrackOverlayType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel prepareAssemblyOverlay(BlockGetter world, BlockPos pos, BlockState state, Direction direction, PoseStack ms) {
        return ((TrackBlock)AllBlocks.TRACK.get()).prepareAssemblyOverlay(world, pos, state, direction, ms);
    }

    public TrackMaterial getMaterial() {
        return CRTrackMaterials.PHANTOM;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        ArrayList stacks = new ArrayList();
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, stacks);
    }

    public Class<GenericCrossingBlockEntity> getBlockEntityClass() {
        return GenericCrossingBlockEntity.class;
    }

    public BlockEntityType<? extends GenericCrossingBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CRBlockEntities.GENERIC_CROSSING.get();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.getFullShape(state);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter pLevel, BlockPos pPos) {
        return this.getFullShape(state);
    }

    private VoxelShape getFullShape(BlockState state) {
        switch ((TrackShape)state.m_61143_(SHAPE)) {
            case AE: {
                return AllShapes.TRACK_ASC.get(Direction.EAST);
            }
            case AW: {
                return AllShapes.TRACK_ASC.get(Direction.WEST);
            }
            case AN: {
                return AllShapes.TRACK_ASC.get(Direction.NORTH);
            }
            case AS: {
                return AllShapes.TRACK_ASC.get(Direction.SOUTH);
            }
            case CR_D: {
                return AllShapes.TRACK_CROSS_DIAG;
            }
            case CR_NDX: {
                return AllShapes.TRACK_CROSS_ORTHO_DIAG.get(Direction.SOUTH);
            }
            case CR_NDZ: {
                return AllShapes.TRACK_CROSS_DIAG_ORTHO.get(Direction.SOUTH);
            }
            case CR_O: {
                return AllShapes.TRACK_CROSS;
            }
            case CR_PDX: {
                return AllShapes.TRACK_CROSS_DIAG_ORTHO.get(Direction.EAST);
            }
            case CR_PDZ: {
                return AllShapes.TRACK_CROSS_ORTHO_DIAG.get(Direction.EAST);
            }
            case ND: {
                return AllShapes.TRACK_DIAG.get(Direction.SOUTH);
            }
            case PD: {
                return AllShapes.TRACK_DIAG.get(Direction.EAST);
            }
            case XO: {
                return AllShapes.TRACK_ORTHO.get(Direction.EAST);
            }
            case ZO: {
                return AllShapes.TRACK_ORTHO.get(Direction.SOUTH);
            }
            case TE: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.EAST);
            }
            case TW: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.WEST);
            }
            case TS: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.SOUTH);
            }
            case TN: {
                return AllShapes.TRACK_ORTHO_LONG.get(Direction.NORTH);
            }
        }
        return AllShapes.TRACK_FALLBACK;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((TrackShape)pState.m_61143_(SHAPE)) {
            case TrackShape.AE, TrackShape.AW, TrackShape.AN, TrackShape.AS -> Shapes.m_83040_();
            default -> AllShapes.TRACK_COLLISION;
        };
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource p_60465_) {
        TrackPropagator.onRailAdded((LevelAccessor)level, (BlockPos)pos, (BlockState)state);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() == this) {
            return;
        }
        if (pLevel.f_46443_) {
            return;
        }
        LevelTickAccess blockTicks = pLevel.m_183326_();
        if (!blockTicks.m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public Collection<TrackNodeLocation.DiscoveredLocation> getConnected(BlockGetter worldIn, BlockPos pos, BlockState state, boolean linear, TrackNodeLocation connectedTo) {
        ArrayList list;
        BlockGetter world;
        if (connectedTo != null && worldIn instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)worldIn;
            v0 = sl.m_7654_().m_129880_(connectedTo.dimension);
        } else {
            v0 = world = worldIn;
        }
        if (this.getTrackAxes(world, pos, state).size() > 1) {
            Vec3 center = Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, this.getElevationAtCenter(world, pos, state), 0.0);
            TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
            list = new ArrayList();
            for (Vec3 axis : this.getTrackAxes(world, pos, state)) {
                for (boolean fromCenter : Iterate.trueAndFalse) {
                    ITrackBlock.addToListIfConnected((TrackNodeLocation)connectedTo, list, (d, b) -> axis.m_82490_(b != false ? 0.0 : (fromCenter ? -d.doubleValue() : d)).m_82549_(center), b -> shape.getNormal(), b -> {
                        ResourceKey resourceKey;
                        if (world instanceof Level) {
                            Level l = (Level)world;
                            resourceKey = l.m_46472_();
                        } else {
                            resourceKey = Level.f_46428_;
                        }
                        return resourceKey;
                    }, v -> 0, (Vec3)axis, null, (b, v) -> ITrackBlock.getMaterialSimple((BlockGetter)world, (Vec3)v));
                }
            }
        } else {
            list = super.getConnected(world, pos, state, linear, connectedTo);
        }
        return list;
    }

    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        super.m_5707_(pLevel, pPos, pState, pPlayer);
        if (pLevel.m_5776_()) {
            return;
        }
        if (!pPlayer.m_7500_()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)pLevel, pPos, be -> {
            be.cancelDrops = true;
        });
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        BlockEntity blockEntity;
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        if (!level.f_46443_ && (blockEntity = level.m_7702_(context.m_8083_())) instanceof GenericCrossingBlockEntity) {
            GenericCrossingBlockEntity crossingBE = (GenericCrossingBlockEntity)blockEntity;
            crossingBE.cancelDrops = true;
            if (!player.m_7500_()) {
                Item a = crossingBE.getPrimary().getBlock().m_5456_();
                Item b = crossingBE.getSecondary().getBlock().m_5456_();
                player.m_150109_().m_150079_(new ItemStack((ItemLike)a));
                player.m_150109_().m_150079_(new ItemStack((ItemLike)b));
            }
        }
        return super.onSneakWrenched(state, context);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof GenericCrossingBlockEntity) {
                GenericCrossingBlockEntity crossingBE = (GenericCrossingBlockEntity)blockEntity;
                if (!crossingBE.cancelDrops) {
                    Item a = crossingBE.getPrimary().getBlock().m_5456_();
                    Item b = crossingBE.getSecondary().getBlock().m_5456_();
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)a));
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)b));
                }
            }
            TrackPropagator.onRailRemoved((LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

